/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;

public class ObjectDeleteOptions {
    private final String bucketName;
    private final String etag;
    private final String namespace;
    private final String objectName;
    private final String opcClientRequestId;
    private final String versionId;
    private static final String NEW_LINE = System.getProperty("line.separator");

    private ObjectDeleteOptions(Builder builder) {
        this.validate(builder);
        this.bucketName = builder.bucketName;
        this.etag = builder.etag;
        this.namespace = builder.namespace;
        this.objectName = builder.objectName;
        this.opcClientRequestId = builder.opcClientRequestId;
        this.versionId = builder.versionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getETag() {
        return this.etag;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    private void validate(Builder builder) {
        StringBuilder sb = new StringBuilder();
        if (OCIUtils.isEmpty(builder.namespace)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_NAMESPACE")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.bucketName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_BUCKETNAME")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty(builder.objectName)) {
            sb.append(Messages.getString("OBJECTSTORAGE_ERROR_REQUIRE_OBJECTNAME")).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageException(sb.toString());
        }
    }

    public static Builder builder(String namespace, String bucketName, String objectName) {
        return new Builder(namespace, bucketName, objectName);
    }

    public static final class Builder {
        private final String bucketName;
        private final String namespace;
        private final String objectName;
        private String etag;
        private String opcClientRequestId;
        private String versionId;

        private Builder(String namespace, String bucketName, String objectName) {
            this.namespace = namespace;
            this.bucketName = bucketName;
            this.objectName = objectName;
        }

        public ObjectDeleteOptions build() {
            return new ObjectDeleteOptions(this);
        }

        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }
    }
}

