/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasetools.DatabaseToolsAsync;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionCollection;
import com.oracle.bmc.databasetools.model.DatabaseToolsEndpointService;
import com.oracle.bmc.databasetools.model.DatabaseToolsEndpointServiceCollection;
import com.oracle.bmc.databasetools.model.DatabaseToolsPrivateEndpoint;
import com.oracle.bmc.databasetools.model.DatabaseToolsPrivateEndpointCollection;
import com.oracle.bmc.databasetools.model.ValidateDatabaseToolsConnectionResult;
import com.oracle.bmc.databasetools.model.WorkRequest;
import com.oracle.bmc.databasetools.model.WorkRequestCollection;
import com.oracle.bmc.databasetools.model.WorkRequestErrorCollection;
import com.oracle.bmc.databasetools.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.databasetools.requests.AddDatabaseToolsConnectionLockRequest;
import com.oracle.bmc.databasetools.requests.AddDatabaseToolsPrivateEndpointLockRequest;
import com.oracle.bmc.databasetools.requests.ChangeDatabaseToolsConnectionCompartmentRequest;
import com.oracle.bmc.databasetools.requests.ChangeDatabaseToolsPrivateEndpointCompartmentRequest;
import com.oracle.bmc.databasetools.requests.CreateDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.CreateDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.requests.DeleteDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.DeleteDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsEndpointServiceRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsConnectionsRequest;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsEndpointServicesRequest;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsPrivateEndpointsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasetools.requests.RemoveDatabaseToolsConnectionLockRequest;
import com.oracle.bmc.databasetools.requests.RemoveDatabaseToolsPrivateEndpointLockRequest;
import com.oracle.bmc.databasetools.requests.UpdateDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.UpdateDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.requests.ValidateDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.responses.AddDatabaseToolsConnectionLockResponse;
import com.oracle.bmc.databasetools.responses.AddDatabaseToolsPrivateEndpointLockResponse;
import com.oracle.bmc.databasetools.responses.ChangeDatabaseToolsConnectionCompartmentResponse;
import com.oracle.bmc.databasetools.responses.ChangeDatabaseToolsPrivateEndpointCompartmentResponse;
import com.oracle.bmc.databasetools.responses.CreateDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.CreateDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.databasetools.responses.DeleteDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.DeleteDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsEndpointServiceResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.databasetools.responses.GetWorkRequestResponse;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsConnectionsResponse;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsEndpointServicesResponse;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsPrivateEndpointsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestsResponse;
import com.oracle.bmc.databasetools.responses.RemoveDatabaseToolsConnectionLockResponse;
import com.oracle.bmc.databasetools.responses.RemoveDatabaseToolsPrivateEndpointLockResponse;
import com.oracle.bmc.databasetools.responses.UpdateDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.UpdateDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.databasetools.responses.ValidateDatabaseToolsConnectionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseToolsAsyncClient
extends BaseAsyncClient
implements DatabaseToolsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASETOOLS").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbtools.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseToolsAsyncClient.class);

    DatabaseToolsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddDatabaseToolsConnectionLockResponse> addDatabaseToolsConnectionLock(AddDatabaseToolsConnectionLockRequest request, AsyncHandler<AddDatabaseToolsConnectionLockRequest, AddDatabaseToolsConnectionLockResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddResourceLockDetails(), "addResourceLockDetails is required");
        return this.clientCall(request, AddDatabaseToolsConnectionLockResponse::builder).logger(LOG, "addDatabaseToolsConnectionLock").serviceDetails("DatabaseTools", "AddDatabaseToolsConnectionLock", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/AddDatabaseToolsConnectionLock").method(Method.POST).requestBuilder(AddDatabaseToolsConnectionLockRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DatabaseToolsConnection.class, AddDatabaseToolsConnectionLockResponse.Builder::databaseToolsConnection).handleResponseHeaderString("opc-request-id", AddDatabaseToolsConnectionLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddDatabaseToolsConnectionLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<AddDatabaseToolsPrivateEndpointLockResponse> addDatabaseToolsPrivateEndpointLock(AddDatabaseToolsPrivateEndpointLockRequest request, AsyncHandler<AddDatabaseToolsPrivateEndpointLockRequest, AddDatabaseToolsPrivateEndpointLockResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddResourceLockDetails(), "addResourceLockDetails is required");
        return this.clientCall(request, AddDatabaseToolsPrivateEndpointLockResponse::builder).logger(LOG, "addDatabaseToolsPrivateEndpointLock").serviceDetails("DatabaseTools", "AddDatabaseToolsPrivateEndpointLock", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/AddDatabaseToolsPrivateEndpointLock").method(Method.POST).requestBuilder(AddDatabaseToolsPrivateEndpointLockRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DatabaseToolsPrivateEndpoint.class, AddDatabaseToolsPrivateEndpointLockResponse.Builder::databaseToolsPrivateEndpoint).handleResponseHeaderString("opc-request-id", AddDatabaseToolsPrivateEndpointLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AddDatabaseToolsPrivateEndpointLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ChangeDatabaseToolsConnectionCompartmentResponse> changeDatabaseToolsConnectionCompartment(ChangeDatabaseToolsConnectionCompartmentRequest request, AsyncHandler<ChangeDatabaseToolsConnectionCompartmentRequest, ChangeDatabaseToolsConnectionCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseToolsConnectionCompartmentDetails(), "changeDatabaseToolsConnectionCompartmentDetails is required");
        return this.clientCall(request, ChangeDatabaseToolsConnectionCompartmentResponse::builder).logger(LOG, "changeDatabaseToolsConnectionCompartment").serviceDetails("DatabaseTools", "ChangeDatabaseToolsConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/ChangeDatabaseToolsConnectionCompartment").method(Method.POST).requestBuilder(ChangeDatabaseToolsConnectionCompartmentRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatabaseToolsConnectionCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatabaseToolsConnectionCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDatabaseToolsPrivateEndpointCompartmentResponse> changeDatabaseToolsPrivateEndpointCompartment(ChangeDatabaseToolsPrivateEndpointCompartmentRequest request, AsyncHandler<ChangeDatabaseToolsPrivateEndpointCompartmentRequest, ChangeDatabaseToolsPrivateEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseToolsPrivateEndpointCompartmentDetails(), "changeDatabaseToolsPrivateEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangeDatabaseToolsPrivateEndpointCompartmentResponse::builder).logger(LOG, "changeDatabaseToolsPrivateEndpointCompartment").serviceDetails("DatabaseTools", "ChangeDatabaseToolsPrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/ChangeDatabaseToolsPrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangeDatabaseToolsPrivateEndpointCompartmentRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatabaseToolsPrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatabaseToolsPrivateEndpointCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDatabaseToolsConnectionResponse> createDatabaseToolsConnection(CreateDatabaseToolsConnectionRequest request, AsyncHandler<CreateDatabaseToolsConnectionRequest, CreateDatabaseToolsConnectionResponse> handler) {
        Objects.requireNonNull(request.getCreateDatabaseToolsConnectionDetails(), "createDatabaseToolsConnectionDetails is required");
        return this.clientCall(request, CreateDatabaseToolsConnectionResponse::builder).logger(LOG, "createDatabaseToolsConnection").serviceDetails("DatabaseTools", "CreateDatabaseToolsConnection", "").method(Method.POST).requestBuilder(CreateDatabaseToolsConnectionRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DatabaseToolsConnection.class, CreateDatabaseToolsConnectionResponse.Builder::databaseToolsConnection).handleResponseHeaderString("location", CreateDatabaseToolsConnectionResponse.Builder::location).handleResponseHeaderString("etag", CreateDatabaseToolsConnectionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDatabaseToolsConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatabaseToolsConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDatabaseToolsPrivateEndpointResponse> createDatabaseToolsPrivateEndpoint(CreateDatabaseToolsPrivateEndpointRequest request, AsyncHandler<CreateDatabaseToolsPrivateEndpointRequest, CreateDatabaseToolsPrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateDatabaseToolsPrivateEndpointDetails(), "createDatabaseToolsPrivateEndpointDetails is required");
        return this.clientCall(request, CreateDatabaseToolsPrivateEndpointResponse::builder).logger(LOG, "createDatabaseToolsPrivateEndpoint").serviceDetails("DatabaseTools", "CreateDatabaseToolsPrivateEndpoint", "").method(Method.POST).requestBuilder(CreateDatabaseToolsPrivateEndpointRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DatabaseToolsPrivateEndpoint.class, CreateDatabaseToolsPrivateEndpointResponse.Builder::databaseToolsPrivateEndpoint).handleResponseHeaderString("location", CreateDatabaseToolsPrivateEndpointResponse.Builder::location).handleResponseHeaderString("etag", CreateDatabaseToolsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDatabaseToolsPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatabaseToolsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDatabaseToolsConnectionResponse> deleteDatabaseToolsConnection(DeleteDatabaseToolsConnectionRequest request, AsyncHandler<DeleteDatabaseToolsConnectionRequest, DeleteDatabaseToolsConnectionResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDatabaseToolsConnectionResponse::builder).logger(LOG, "deleteDatabaseToolsConnection").serviceDetails("DatabaseTools", "DeleteDatabaseToolsConnection", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/DeleteDatabaseToolsConnection").method(Method.DELETE).requestBuilder(DeleteDatabaseToolsConnectionRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDatabaseToolsConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatabaseToolsConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDatabaseToolsPrivateEndpointResponse> deleteDatabaseToolsPrivateEndpoint(DeleteDatabaseToolsPrivateEndpointRequest request, AsyncHandler<DeleteDatabaseToolsPrivateEndpointRequest, DeleteDatabaseToolsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDatabaseToolsPrivateEndpointResponse::builder).logger(LOG, "deleteDatabaseToolsPrivateEndpoint").serviceDetails("DatabaseTools", "DeleteDatabaseToolsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/DeleteDatabaseToolsPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteDatabaseToolsPrivateEndpointRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDatabaseToolsPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatabaseToolsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseToolsConnectionResponse> getDatabaseToolsConnection(GetDatabaseToolsConnectionRequest request, AsyncHandler<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatabaseToolsConnectionResponse::builder).logger(LOG, "getDatabaseToolsConnection").serviceDetails("DatabaseTools", "GetDatabaseToolsConnection", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/GetDatabaseToolsConnection").method(Method.GET).requestBuilder(GetDatabaseToolsConnectionRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsConnection.class, GetDatabaseToolsConnectionResponse.Builder::databaseToolsConnection).handleResponseHeaderString("etag", GetDatabaseToolsConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatabaseToolsConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseToolsEndpointServiceResponse> getDatabaseToolsEndpointService(GetDatabaseToolsEndpointServiceRequest request, AsyncHandler<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsEndpointServiceId(), (String)"databaseToolsEndpointServiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatabaseToolsEndpointServiceResponse::builder).logger(LOG, "getDatabaseToolsEndpointService").serviceDetails("DatabaseTools", "GetDatabaseToolsEndpointService", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsEndpointService/GetDatabaseToolsEndpointService").method(Method.GET).requestBuilder(GetDatabaseToolsEndpointServiceRequest::builder).basePath("/20201005").appendPathParam("databaseToolsEndpointServices").appendPathParam(request.getDatabaseToolsEndpointServiceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsEndpointService.class, GetDatabaseToolsEndpointServiceResponse.Builder::databaseToolsEndpointService).handleResponseHeaderString("etag", GetDatabaseToolsEndpointServiceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatabaseToolsEndpointServiceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseToolsPrivateEndpointResponse> getDatabaseToolsPrivateEndpoint(GetDatabaseToolsPrivateEndpointRequest request, AsyncHandler<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatabaseToolsPrivateEndpointResponse::builder).logger(LOG, "getDatabaseToolsPrivateEndpoint").serviceDetails("DatabaseTools", "GetDatabaseToolsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/GetDatabaseToolsPrivateEndpoint").method(Method.GET).requestBuilder(GetDatabaseToolsPrivateEndpointRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsPrivateEndpoint.class, GetDatabaseToolsPrivateEndpointResponse.Builder::databaseToolsPrivateEndpoint).handleResponseHeaderString("etag", GetDatabaseToolsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatabaseToolsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DatabaseTools", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20201005").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListDatabaseToolsConnectionsResponse> listDatabaseToolsConnections(ListDatabaseToolsConnectionsRequest request, AsyncHandler<ListDatabaseToolsConnectionsRequest, ListDatabaseToolsConnectionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDatabaseToolsConnectionsResponse::builder).logger(LOG, "listDatabaseToolsConnections").serviceDetails("DatabaseTools", "ListDatabaseToolsConnections", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/ListDatabaseToolsConnections").method(Method.GET).requestBuilder(ListDatabaseToolsConnectionsRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendListQueryParam("runtimeSupport", request.getRuntimeSupport(), CollectionFormatType.Multi).appendQueryParam("relatedResourceIdentifier", (Object)request.getRelatedResourceIdentifier()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsConnectionCollection.class, ListDatabaseToolsConnectionsResponse.Builder::databaseToolsConnectionCollection).handleResponseHeaderString("opc-request-id", ListDatabaseToolsConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatabaseToolsConnectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDatabaseToolsEndpointServicesResponse> listDatabaseToolsEndpointServices(ListDatabaseToolsEndpointServicesRequest request, AsyncHandler<ListDatabaseToolsEndpointServicesRequest, ListDatabaseToolsEndpointServicesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDatabaseToolsEndpointServicesResponse::builder).logger(LOG, "listDatabaseToolsEndpointServices").serviceDetails("DatabaseTools", "ListDatabaseToolsEndpointServices", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsEndpointService/ListDatabaseToolsEndpointServices").method(Method.GET).requestBuilder(ListDatabaseToolsEndpointServicesRequest::builder).basePath("/20201005").appendPathParam("databaseToolsEndpointServices").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsEndpointServiceCollection.class, ListDatabaseToolsEndpointServicesResponse.Builder::databaseToolsEndpointServiceCollection).handleResponseHeaderString("opc-request-id", ListDatabaseToolsEndpointServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatabaseToolsEndpointServicesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDatabaseToolsPrivateEndpointsResponse> listDatabaseToolsPrivateEndpoints(ListDatabaseToolsPrivateEndpointsRequest request, AsyncHandler<ListDatabaseToolsPrivateEndpointsRequest, ListDatabaseToolsPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDatabaseToolsPrivateEndpointsResponse::builder).logger(LOG, "listDatabaseToolsPrivateEndpoints").serviceDetails("DatabaseTools", "ListDatabaseToolsPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/ListDatabaseToolsPrivateEndpoints").method(Method.GET).requestBuilder(ListDatabaseToolsPrivateEndpointsRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subnetId", (Object)request.getSubnetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("endpointServiceId", (Object)request.getEndpointServiceId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseToolsPrivateEndpointCollection.class, ListDatabaseToolsPrivateEndpointsResponse.Builder::databaseToolsPrivateEndpointCollection).handleResponseHeaderString("opc-request-id", ListDatabaseToolsPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatabaseToolsPrivateEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DatabaseTools", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20201005").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DatabaseTools", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20201005").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DatabaseTools", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20201005").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceIdentifier", (Object)request.getResourceIdentifier()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RemoveDatabaseToolsConnectionLockResponse> removeDatabaseToolsConnectionLock(RemoveDatabaseToolsConnectionLockRequest request, AsyncHandler<RemoveDatabaseToolsConnectionLockRequest, RemoveDatabaseToolsConnectionLockResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceLockDetails(), "removeResourceLockDetails is required");
        return this.clientCall(request, RemoveDatabaseToolsConnectionLockResponse::builder).logger(LOG, "removeDatabaseToolsConnectionLock").serviceDetails("DatabaseTools", "RemoveDatabaseToolsConnectionLock", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/RemoveDatabaseToolsConnectionLock").method(Method.POST).requestBuilder(RemoveDatabaseToolsConnectionLockRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DatabaseToolsConnection.class, RemoveDatabaseToolsConnectionLockResponse.Builder::databaseToolsConnection).handleResponseHeaderString("opc-request-id", RemoveDatabaseToolsConnectionLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveDatabaseToolsConnectionLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RemoveDatabaseToolsPrivateEndpointLockResponse> removeDatabaseToolsPrivateEndpointLock(RemoveDatabaseToolsPrivateEndpointLockRequest request, AsyncHandler<RemoveDatabaseToolsPrivateEndpointLockRequest, RemoveDatabaseToolsPrivateEndpointLockResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveResourceLockDetails(), "removeResourceLockDetails is required");
        return this.clientCall(request, RemoveDatabaseToolsPrivateEndpointLockResponse::builder).logger(LOG, "removeDatabaseToolsPrivateEndpointLock").serviceDetails("DatabaseTools", "RemoveDatabaseToolsPrivateEndpointLock", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/RemoveDatabaseToolsPrivateEndpointLock").method(Method.POST).requestBuilder(RemoveDatabaseToolsPrivateEndpointLockRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DatabaseToolsPrivateEndpoint.class, RemoveDatabaseToolsPrivateEndpointLockResponse.Builder::databaseToolsPrivateEndpoint).handleResponseHeaderString("opc-request-id", RemoveDatabaseToolsPrivateEndpointLockResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RemoveDatabaseToolsPrivateEndpointLockResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateDatabaseToolsConnectionResponse> updateDatabaseToolsConnection(UpdateDatabaseToolsConnectionRequest request, AsyncHandler<UpdateDatabaseToolsConnectionRequest, UpdateDatabaseToolsConnectionResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatabaseToolsConnectionDetails(), "updateDatabaseToolsConnectionDetails is required");
        return this.clientCall(request, UpdateDatabaseToolsConnectionResponse::builder).logger(LOG, "updateDatabaseToolsConnection").serviceDetails("DatabaseTools", "UpdateDatabaseToolsConnection", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/UpdateDatabaseToolsConnection").method(Method.PUT).requestBuilder(UpdateDatabaseToolsConnectionRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDatabaseToolsConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDatabaseToolsConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDatabaseToolsPrivateEndpointResponse> updateDatabaseToolsPrivateEndpoint(UpdateDatabaseToolsPrivateEndpointRequest request, AsyncHandler<UpdateDatabaseToolsPrivateEndpointRequest, UpdateDatabaseToolsPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsPrivateEndpointId(), (String)"databaseToolsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatabaseToolsPrivateEndpointDetails(), "updateDatabaseToolsPrivateEndpointDetails is required");
        return this.clientCall(request, UpdateDatabaseToolsPrivateEndpointResponse::builder).logger(LOG, "updateDatabaseToolsPrivateEndpoint").serviceDetails("DatabaseTools", "UpdateDatabaseToolsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsPrivateEndpoint/UpdateDatabaseToolsPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateDatabaseToolsPrivateEndpointRequest::builder).basePath("/20201005").appendPathParam("databaseToolsPrivateEndpoints").appendPathParam(request.getDatabaseToolsPrivateEndpointId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDatabaseToolsPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDatabaseToolsPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ValidateDatabaseToolsConnectionResponse> validateDatabaseToolsConnection(ValidateDatabaseToolsConnectionRequest request, AsyncHandler<ValidateDatabaseToolsConnectionRequest, ValidateDatabaseToolsConnectionResponse> handler) {
        Validate.notBlank((String)request.getDatabaseToolsConnectionId(), (String)"databaseToolsConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getValidateDatabaseToolsConnectionDetails(), "validateDatabaseToolsConnectionDetails is required");
        return this.clientCall(request, ValidateDatabaseToolsConnectionResponse::builder).logger(LOG, "validateDatabaseToolsConnection").serviceDetails("DatabaseTools", "ValidateDatabaseToolsConnection", "https://docs.oracle.com/iaas/api/#/en/database-tools/20201005/DatabaseToolsConnection/ValidateDatabaseToolsConnection").method(Method.POST).requestBuilder(ValidateDatabaseToolsConnectionRequest::builder).basePath("/20201005").appendPathParam("databaseToolsConnections").appendPathParam(request.getDatabaseToolsConnectionId()).appendPathParam("actions").appendPathParam("validateConnection").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ValidateDatabaseToolsConnectionResult.class, ValidateDatabaseToolsConnectionResponse.Builder::validateDatabaseToolsConnectionResult).handleResponseHeaderString("opc-request-id", ValidateDatabaseToolsConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DatabaseToolsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DatabaseToolsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DatabaseToolsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DatabaseToolsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DatabaseToolsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DatabaseToolsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DatabaseToolsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseToolsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseToolsAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "databasetools";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"databasetools");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DatabaseToolsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DatabaseToolsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

