/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;

public class ExceptionUtil {
    public static void logExceptionUnsupported(Connection conn, String methodName, String className) throws SQLException {
        LogUtil.logOrException(conn, Level.INFO, ExceptionUtil.exceptionMessageStr(true, methodName, className), new SQLFeatureNotSupportedException(ExceptionUtil.exceptionMessageStr(true, methodName, className), "0A000", 3000));
    }

    private static String exceptionMessageStr(boolean unsupport, String methodName, String className) {
        if (unsupport) {
            return RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, className);
        }
        return RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", methodName, className);
    }

    public static void throwSQLException(int errorCode) throws SQLException {
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    public static void throwSQLException(int errorCode, String methodName) throws SQLException {
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, methodName), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    public static void throwSQLException(String methodName, String className) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, className));
    }

    public static void throwSQLException(int errorCode, Exception e) throws SQLException {
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode, e);
    }

    public static String getErrorMessage(int errorCode, String methodName) {
        String ORAError = "ORA_" + errorCode;
        return ExceptionUtil.getErrorMessage(errorCode, () -> RestjdbcResources.getString(ORAError) + ": " + methodName);
    }

    public static String getErrorMessage(int errorCode) {
        String ORAError = "ORA_" + errorCode;
        return ExceptionUtil.getErrorMessage(errorCode, () -> RestjdbcResources.getString(ORAError));
    }

    public static String getErrorMessage(int errorCode, Supplier<String> messageSupplier) {
        String ORAError = "ORA_" + errorCode;
        String ORAErrorDashed = ORAError.replace("_", "-");
        return RestjdbcResources.format("ERROR_MESSAGE_FORMAT", ORAErrorDashed, messageSupplier.get(), String.valueOf(errorCode));
    }
}

