/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;
import oracle.dbtools.jdbc.Connection;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static String DRIVER_VERSION = "12.2.0.1.0";
    private static final String DATABASE_METADATA_QUERY = "WITH dbversion as (SELECT banner FROM v$version WHERE banner LIKE 'Oracle%'),      dboptions as (SELECT parameter , value ,rownum from v$option WHERE parameter IN('Partitioning','Real Application Testing','OLAP','Advanced Analytics') AND value='TRUE'),      dboptionstr as (SELECT listagg(o.parameter, ', ') within group (order by rownum) as optionstr FROM dboptions o  ),      dboptionstrmod as (SELECT substr(optionstr,0,instr(optionstr,',',-1)-1) || ' and ' ||ltrim(substr(optionstr,instr(optionstr,',',-1)+1))  as optionstrmod from dboptionstr)  SELECT v.banner, 'With the ' ||optionstrmod ||' options' , USER FROM dbversion v,  dboptionstrmod s ";
    private static final String DATABASE_METADATA_QUERY_NOVVERSION = "select rtrim(product) || /* space already in product might change-> rtrim */ ' Release ' || version || ' - ' || status, user from product_component_version where product like 'Oracle Database%'";
    private static final String DATABASE_MAJOR_MINOR = "BEGIN :MAJOR:=DBMS_DB_VERSION.version; :MINOR:=DBMS_DB_VERSION.release; end;";
    private final java.sql.Connection conn;
    private final String productVersion;
    private final String productOptions;
    private final String userName;
    private final int productMajorVersion;
    private final int productMinorVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMetaData(java.sql.Connection connection) throws SQLException {
        block16: {
            this.conn = connection;
            String tmpUserName = null;
            String tmpProductVersion = null;
            String tmpProductOptions = null;
            try (CallableStatement cstmt = null;){
                cstmt = connection.prepareCall(DATABASE_MAJOR_MINOR);
                cstmt.registerOutParameter(1, 4);
                cstmt.registerOutParameter(2, 4);
                cstmt.execute();
                this.productMajorVersion = cstmt.getInt(1);
                this.productMinorVersion = cstmt.getInt(2);
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = connection.createStatement();
                rs = stmt.executeQuery(DATABASE_METADATA_QUERY);
                if (rs.next()) {
                    tmpProductVersion = rs.getString(1);
                    tmpProductOptions = rs.getString(2);
                    tmpUserName = rs.getString(3);
                    break block16;
                }
                throw new SQLException("failed to gather productVersion and productOptions information for DatabaseMetaData");
            }
            catch (SQLException se) {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if ((rs = (stmt = connection.createStatement()).executeQuery(DATABASE_METADATA_QUERY_NOVVERSION)).next()) {
                    tmpProductVersion = rs.getString(1);
                    tmpUserName = rs.getString(2);
                    break block16;
                }
                throw new SQLException("failed to gather productVersion and productOptions information for DatabaseMetaData");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                this.productVersion = tmpProductVersion;
                this.productOptions = tmpProductOptions;
                this.userName = tmpUserName;
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        String retURL = ((Connection)this.getConn()).getURL();
        return retURL;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Oracle";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.getProductVersion() + "\n" + this.getProductOptions();
    }

    private String getProductOptions() {
        if (this.productOptions == null) {
            return "";
        }
        return this.productOptions;
    }

    private String getProductVersion() {
        if (this.productVersion == null) {
            return "Oracle Database . Unknown version";
        }
        return this.productVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return ((Connection)this.conn).getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 12;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return null;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return null;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return null;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String[] stringArray;
        Object[] objectArray = new Object[1];
        if (types != null) {
            stringArray = types;
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "TABLE";
            stringArray2[1] = "VIEW";
            stringArray = stringArray2;
            stringArray2[2] = "SYNONYM";
        }
        objectArray[0] = Arrays.stream(stringArray).map(s -> String.format("'%s'", s.toUpperCase())).collect(Collectors.joining(","));
        String query = String.format("SELECT     NULL AS TABLE_CAT,    O.OWNER AS TABLE_SCHEM,    O.OBJECT_NAME AS TABLE_NAME,    O.OBJECT_TYPE AS TABLE_TYPE,    C.COMMENTS AS REMARKS,    NULL AS TYPE_CAT,    NULL AS TYPE_SCHEM,    NULL AS TYPE_NAME,    NULL AS SELF_REFERENCING_COL_NAME,    NULL AS REF_GENERATION FROM     ALL_OBJECTS O LEFT JOIN     ALL_TAB_COMMENTS C     ON O.OWNER = C.OWNER AND O.OBJECT_NAME = C.TABLE_NAME  WHERE  O.OWNER LIKE ?   AND  O.OBJECT_NAME LIKE ?  AND  O.OBJECT_TYPE IN (%s) ORDER BY     O.OBJECT_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME", objectArray);
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
            ps.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try (Statement s = this.getConnection().createStatement();){
            ResultSet resultSet = s.executeQuery("SELECT NULL AS TABLE_CAT FROM DUAL WHERE 1=2");
            return resultSet;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String query = "select 'TABLE' as table_type from dual union select 'VIEW' as table_type from dual union select 'SYNONYM' as table_type from dual order by table_type";
        try (Statement s = this.getConnection().createStatement();){
            ResultSet resultSet = s.executeQuery("select 'TABLE' as table_type from dual union select 'VIEW' as table_type from dual union select 'SYNONYM' as table_type from dual order by table_type");
            return resultSet;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "SELECT \n    NULL AS TABLE_CAT,\n    OWNER AS TABLE_SCHEM,\n    TABLE_NAME,\n    COLUMN_NAME,\nCASE\n    WHEN DATA_TYPE = 'CHAR' THEN 1\n    WHEN DATA_TYPE = 'VARCHAR2' THEN 12\n    WHEN DATA_TYPE = 'NVARCHAR2' THEN -9\n    WHEN DATA_TYPE = 'DATE' THEN 93\n    WHEN DATA_TYPE = 'TIMESTAMP' THEN 93\n    WHEN DATA_TYPE like 'TIMESTAMP% WITH TIME ZONE' THEN -101\n    WHEN DATA_TYPE like 'TIMESTAMP% WITH LOCAL TIME ZONE' THEN -102\n    WHEN DATA_TYPE = 'BLOB' THEN 2004\n    WHEN DATA_TYPE = 'CLOB' THEN 2005\n    WHEN DATA_TYPE = 'NCLOB' THEN 2011\n WHEN DATA_TYPE = 'JSON' THEN  2016 \n WHEN DATA_TYPE = 'NUMBER' THEN 2\n    WHEN DATA_TYPE = 'FLOAT' THEN 6\n    WHEN DATA_TYPE = 'BINARY_FLOAT' THEN 100\n    WHEN DATA_TYPE = 'BINARY_DOUBLE' THEN 101\n    ELSE 0\nEND AS DATA_TYPE,\n   DATA_TYPE AS TYPE_NAME,\nCASE \n    WHEN DATA_TYPE = 'NUMBER' THEN \n        CASE \n            WHEN DATA_PRECISION IS NULL THEN 0\n          ELSE DATA_PRECISION\n        END\n    WHEN DATA_TYPE = 'FLOAT' THEN \n        CASE \n            WHEN DATA_PRECISION IS NULL THEN 126 \n            ELSE DATA_PRECISION \n        END\n    ELSE DATA_LENGTH\n END AS COLUMN_SIZE,\n    0 AS BUFFER_LENGTH, -- is not used\nCASE \nwhen Data_scale is null and data_type in ('NUMBER') then -127\nelse Data_scale \nend as DECIMAL_DIGITS,\n    10 AS NUM_PREC_RADIX,\n    CASE\n        WHEN NULLABLE = 'Y' THEN 1\n        WHEN NULLABLE = 'N' THEN 0\n        ELSE 2\n    END AS NULLABLE,\n    NULL AS REMARKS,\n    DATA_DEFAULT AS COLUMN_DEF,\n    0 AS SQL_DATA_TYPE,\nCASE\n    WHEN DATA_TYPE = 'TIMESTAMP' THEN 2  -- Standard TIMESTAMP\n    WHEN DATA_TYPE = 'TIMESTAMP WITH TIME ZONE' THEN -101 -- Correct mapping for TIMESTAMP with time zone\n    WHEN DATA_TYPE = 'TIMESTAMP WITH LOCAL TIME ZONE' THEN -102  -- Local time zone version\n    ELSE 0  -- Non-date/time types\nEND AS SQL_DATETIME_SUB,DATA_LENGTH  as CHAR_OCTET_LENGTH,\n    COLUMN_ID AS ORDINAL_POSITION,\n    CASE\n        WHEN NULLABLE = 'Y' THEN 'YES'\n        WHEN NULLABLE = 'N' THEN 'NO'\n        ELSE ''\n    END AS IS_NULLABLE,\n    NULL AS SCOPE_CATALOG,\n    NULL AS SCOPE_SCHEMA,\n    NULL AS SCOPE_TABLE,\n    NULL AS SOURCE_DATA_TYPE,\n    CASE\n        WHEN IDENTITY_COLUMN = 'YES' THEN 'YES'\n        ELSE 'NO'\n    END AS IS_AUTOINCREMENT,\n    'NO' AS IS_GENERATEDCOLUMN\nFROM ALL_TAB_COLUMNS\nWHERE OWNER LIKE ? AND TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ?\nORDER BY OWNER, TABLE_NAME, COLUMN_ID";
        try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT \n    NULL AS TABLE_CAT,\n    OWNER AS TABLE_SCHEM,\n    TABLE_NAME,\n    COLUMN_NAME,\nCASE\n    WHEN DATA_TYPE = 'CHAR' THEN 1\n    WHEN DATA_TYPE = 'VARCHAR2' THEN 12\n    WHEN DATA_TYPE = 'NVARCHAR2' THEN -9\n    WHEN DATA_TYPE = 'DATE' THEN 93\n    WHEN DATA_TYPE = 'TIMESTAMP' THEN 93\n    WHEN DATA_TYPE like 'TIMESTAMP% WITH TIME ZONE' THEN -101\n    WHEN DATA_TYPE like 'TIMESTAMP% WITH LOCAL TIME ZONE' THEN -102\n    WHEN DATA_TYPE = 'BLOB' THEN 2004\n    WHEN DATA_TYPE = 'CLOB' THEN 2005\n    WHEN DATA_TYPE = 'NCLOB' THEN 2011\n WHEN DATA_TYPE = 'JSON' THEN  2016 \n WHEN DATA_TYPE = 'NUMBER' THEN 2\n    WHEN DATA_TYPE = 'FLOAT' THEN 6\n    WHEN DATA_TYPE = 'BINARY_FLOAT' THEN 100\n    WHEN DATA_TYPE = 'BINARY_DOUBLE' THEN 101\n    ELSE 0\nEND AS DATA_TYPE,\n   DATA_TYPE AS TYPE_NAME,\nCASE \n    WHEN DATA_TYPE = 'NUMBER' THEN \n        CASE \n            WHEN DATA_PRECISION IS NULL THEN 0\n          ELSE DATA_PRECISION\n        END\n    WHEN DATA_TYPE = 'FLOAT' THEN \n        CASE \n            WHEN DATA_PRECISION IS NULL THEN 126 \n            ELSE DATA_PRECISION \n        END\n    ELSE DATA_LENGTH\n END AS COLUMN_SIZE,\n    0 AS BUFFER_LENGTH, -- is not used\nCASE \nwhen Data_scale is null and data_type in ('NUMBER') then -127\nelse Data_scale \nend as DECIMAL_DIGITS,\n    10 AS NUM_PREC_RADIX,\n    CASE\n        WHEN NULLABLE = 'Y' THEN 1\n        WHEN NULLABLE = 'N' THEN 0\n        ELSE 2\n    END AS NULLABLE,\n    NULL AS REMARKS,\n    DATA_DEFAULT AS COLUMN_DEF,\n    0 AS SQL_DATA_TYPE,\nCASE\n    WHEN DATA_TYPE = 'TIMESTAMP' THEN 2  -- Standard TIMESTAMP\n    WHEN DATA_TYPE = 'TIMESTAMP WITH TIME ZONE' THEN -101 -- Correct mapping for TIMESTAMP with time zone\n    WHEN DATA_TYPE = 'TIMESTAMP WITH LOCAL TIME ZONE' THEN -102  -- Local time zone version\n    ELSE 0  -- Non-date/time types\nEND AS SQL_DATETIME_SUB,DATA_LENGTH  as CHAR_OCTET_LENGTH,\n    COLUMN_ID AS ORDINAL_POSITION,\n    CASE\n        WHEN NULLABLE = 'Y' THEN 'YES'\n        WHEN NULLABLE = 'N' THEN 'NO'\n        ELSE ''\n    END AS IS_NULLABLE,\n    NULL AS SCOPE_CATALOG,\n    NULL AS SCOPE_SCHEMA,\n    NULL AS SCOPE_TABLE,\n    NULL AS SOURCE_DATA_TYPE,\n    CASE\n        WHEN IDENTITY_COLUMN = 'YES' THEN 'YES'\n        ELSE 'NO'\n    END AS IS_AUTOINCREMENT,\n    'NO' AS IS_GENERATEDCOLUMN\nFROM ALL_TAB_COLUMNS\nWHERE OWNER LIKE ? AND TABLE_NAME LIKE ? AND COLUMN_NAME LIKE ?\nORDER BY OWNER, TABLE_NAME, COLUMN_ID");){
            ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
            ps.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
            ps.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P' AND k.table_name = ? AND k.owner like ?\nAND k.constraint_name = c.constraint_name  AND k.table_name = c.table_name \nAND k.owner = c.owner \nORDER BY column_name";
        try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P' AND k.table_name = ? AND k.owner like ?\nAND k.constraint_name = c.constraint_name  AND k.table_name = c.table_name \nAND k.owner = c.owner \nORDER BY column_name");){
            ps.setString(1, table);
            ps.setString(2, schema == null ? "%" : schema);
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT \n    NULL AS PKTABLE_CAT,\n    pk.owner AS PKTABLE_SCHEM,\n    pk.table_name AS PKTABLE_NAME,\n    pcol.column_name AS PKCOLUMN_NAME,\n    NULL AS FKTABLE_CAT,\n    fk.owner AS FKTABLE_SCHEM,\n    fk.table_name AS FKTABLE_NAME,\n    fcol.column_name AS FKCOLUMN_NAME,\n    pcol.position AS KEY_SEQ,\n    NULL AS UPDATE_RULE,\n    CASE \n        WHEN fk.delete_rule = 'NO ACTION' THEN 1\n        WHEN fk.delete_rule = 'CASCADE' THEN 3\n        WHEN fk.delete_rule = 'SET NULL' THEN 2\n        WHEN fk.delete_rule = 'SET DEFAULT' THEN 4\n        WHEN fk.delete_rule = 'RESTRICT' THEN 1 \n        ELSE 1  \n    END AS DELETE_RULE,\n    fk.constraint_name AS FK_NAME,\n    pk.constraint_name AS PK_NAME,\n    CASE \n        WHEN fk.deferrable = 'DEFERRABLE' AND fk.deferred = 'IMMEDIATE' THEN 5 \n        WHEN fk.deferrable = 'DEFERRABLE' AND fk.deferred = 'DEFERRED' THEN 6\n        ELSE 7\n    END AS DEFERRABILITY\nFROM\n    all_cons_columns pcol\n    JOIN all_constraints pk \n        ON pcol.owner = pk.owner\n        AND pcol.constraint_name = pk.constraint_name\n    JOIN all_constraints fk \n        ON fk.r_constraint_name = pk.constraint_name\n        AND fk.constraint_type = 'R'\n    JOIN all_cons_columns fcol \n        ON fk.owner = fcol.owner\n        AND fk.constraint_name = fcol.constraint_name\n        AND fcol.position = pcol.position\nWHERE \n    pk.constraint_type = 'P'\n    AND fk.table_name = UPPER(?)\n    AND (? IS NULL OR fk.owner = UPPER(?))\nORDER BY \n    PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ;\n";
        try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT \n    NULL AS PKTABLE_CAT,\n    pk.owner AS PKTABLE_SCHEM,\n    pk.table_name AS PKTABLE_NAME,\n    pcol.column_name AS PKCOLUMN_NAME,\n    NULL AS FKTABLE_CAT,\n    fk.owner AS FKTABLE_SCHEM,\n    fk.table_name AS FKTABLE_NAME,\n    fcol.column_name AS FKCOLUMN_NAME,\n    pcol.position AS KEY_SEQ,\n    NULL AS UPDATE_RULE,\n    CASE \n        WHEN fk.delete_rule = 'NO ACTION' THEN 1\n        WHEN fk.delete_rule = 'CASCADE' THEN 3\n        WHEN fk.delete_rule = 'SET NULL' THEN 2\n        WHEN fk.delete_rule = 'SET DEFAULT' THEN 4\n        WHEN fk.delete_rule = 'RESTRICT' THEN 1 \n        ELSE 1  \n    END AS DELETE_RULE,\n    fk.constraint_name AS FK_NAME,\n    pk.constraint_name AS PK_NAME,\n    CASE \n        WHEN fk.deferrable = 'DEFERRABLE' AND fk.deferred = 'IMMEDIATE' THEN 5 \n        WHEN fk.deferrable = 'DEFERRABLE' AND fk.deferred = 'DEFERRED' THEN 6\n        ELSE 7\n    END AS DEFERRABILITY\nFROM\n    all_cons_columns pcol\n    JOIN all_constraints pk \n        ON pcol.owner = pk.owner\n        AND pcol.constraint_name = pk.constraint_name\n    JOIN all_constraints fk \n        ON fk.r_constraint_name = pk.constraint_name\n        AND fk.constraint_type = 'R'\n    JOIN all_cons_columns fcol \n        ON fk.owner = fcol.owner\n        AND fk.constraint_name = fcol.constraint_name\n        AND fcol.position = pcol.position\nWHERE \n    pk.constraint_type = 'P'\n    AND fk.table_name = UPPER(?)\n    AND (? IS NULL OR fk.owner = UPPER(?))\nORDER BY \n    PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ;\n");){
            ps.setString(1, table);
            ps.setString(2, schema);
            ps.setString(3, schema);
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.getConn();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.productMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.productMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String query = "SELECT     USERNAME AS TABLE_SCHEM,     NULL AS TABLE_CATALOG\n FROM     ALL_USERS\n WHERE     USERNAME LIKE ? \n ORDER BY     TABLE_CATALOG,     TABLE_SCHEM";
        try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT     USERNAME AS TABLE_SCHEM,     NULL AS TABLE_CATALOG\n FROM     ALL_USERS\n WHERE     USERNAME LIKE ? \n ORDER BY     TABLE_CATALOG,     TABLE_SCHEM");){
            ps.setString(1, schemaPattern == null ? "%" : schemaPattern);
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    public java.sql.Connection getConn() {
        return this.conn;
    }
}

