/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.stream.Stream;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.http.entity.DynamicInputStreamWrapper;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.StoreAndForwardStorageLocation;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.ContentLengthInputStream;
import oracle.dbtools.transfer.utility.InputStreamProgressWrapper;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.RunnableTimer;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.transfer.utility.TransferException;
import oracle.dbtools.util.Pair;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OracleOciStorageLocation
extends StoreAndForwardStorageLocation {
    private static final Class<?> clazz = OracleOciStorageLocation.class;
    private static final String BUCKETS = "b";
    private static final String COMPARTMENTS = "c";
    private static final String OBJECTS = "o";
    private CloudStorageUrl storageUrl;
    private String profile;
    private OCIRESTClient client;
    private String pre = "{\"objects\":";
    private String post = "}";
    private static boolean DUMMY;
    private static String NAMESPACE_URL;
    private static String PROFILE;
    private static String BUCKET;
    private static String OBJECT;
    public static boolean LOG_APACHE_HTTP;
    int OUTPUT_STREAM_MESSAGE_COUNT = 7;
    private static String filePath1;
    private static final String DATE_FORMAT_PATTERN = "yyyymmdd_hhmmssSSS";
    private static final SimpleDateFormat simpleDateFormat;
    static boolean RESERVE_NAME;
    private boolean taskDone = false;
    private static DecimalFormat df;

    public OracleOciStorageLocation(CloudStorageUrl storageUrl, String profile) {
        super(storageUrl, profile);
        this.storageUrl = storageUrl;
        this.profile = profile;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public Location clone() {
        OracleOciStorageLocation clone = new OracleOciStorageLocation(this.storageUrl, this.profile);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectImpl() throws IOException {
        block9: {
            if (null == this.client) {
                try {
                    this.client = new OCIProfiles().getOciClient(this.profile);
                }
                catch (Throwable t) {
                    String msg = "Unable to create client";
                    oracle.dbtools.util.Logger.severe(this.getClass(), (String)msg, (Throwable)t);
                    throw new IOException(msg, t);
                }
            }
            try {
                if (this.storageUrl.isUnknownUrl()) break block9;
                URL namespaceUrl = this.storageUrl.getNamespaceUrlAsOCI();
                OCIRequest request = new OCIRequest.Builder().host(namespaceUrl.getHost()).method("get").target(namespaceUrl.getPath()).build();
                try (CloseableHttpResponse response = this.client.getResponse(request);){
                    if (401 == response.getCode()) {
                        throw new IOException(String.valueOf(response.getReasonPhrase()));
                    }
                }
                oracle.dbtools.util.Logger.info(this.getClass(), (String)this.toString());
            }
            catch (Throwable t) {
                throw OracleOciStorageLocation.asIOException(t);
            }
        }
    }

    @Override
    public void disconnect() {
        while (this.hasTask()) {
            try {
                oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format("Waiting on [\n%s]", this.listTasks()));
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                oracle.dbtools.util.Logger.warn(this.getClass(), (String)"Interrupted waiting on tasks to complete - pending operations may fail", (Throwable)e);
            }
        }
        super.disconnect();
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        return this.asInputStream(path, position, size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream asInputStream(Path path, long position, long size, TransferTaskProgressMonitor progressMonitor) throws IOException {
        InputStream in = null;
        try {
            CloudStorageUrl target = this.getTargetUrl(path);
            target.validateUrlAsObject();
            URL targetUrl = target.getFinalUrlAsOCI();
            OCIRequest request = new OCIRequest.Builder().host(targetUrl.getHost()).method("get").target(targetUrl.getPath()).build();
            boolean rangedRequest = false;
            if (size > 0L) {
                String range = "bytes=" + position + "-" + (position + size - 1L);
                request.addHeader("Range", range);
                rangedRequest = true;
            }
            final CloseableHttpResponse response = this.client.getResponse(request);
            try {
                int statusCode = response.getCode();
                if (!(200 == statusCode || rangedRequest && 206 == statusCode)) {
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    MessageDigest md5MessageDigest;
                    String md5Promised;
                    Header objectManifestHeader;
                    in = entity.getContent();
                    String length = response.getFirstHeader("Content-Length").getValue();
                    int streamLen = null == length ? -1 : Integer.parseInt(length);
                    in = new ContentLengthInputStream(in, streamLen);
                    if (progressMonitor != null) {
                        in = new InputStreamProgressWrapper(in, progressMonitor, streamLen);
                    }
                    if ((objectManifestHeader = response.getFirstHeader("x-object-meta-X-Object-Manifest")) != null) {
                        rangedRequest = true;
                    }
                    String string = md5Promised = rangedRequest ? null : response.getFirstHeader("content-md5").getValue();
                    if (md5Promised != null && !md5Promised.startsWith("\"")) {
                        md5MessageDigest = MD5.getMessageDigest();
                        in = new DigestInputStream(in, md5MessageDigest);
                    } else {
                        md5MessageDigest = null;
                    }
                    in = new FilterInputStream(in){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            response.close();
                            if (md5Promised != null && !md5Promised.startsWith("\"")) {
                                String md5Received = new String(Base64.getEncoder().encodeToString(md5MessageDigest.digest()));
                                if (!md5Promised.equals(md5Received)) {
                                    throw new IOException(String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
                                }
                                oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                            }
                        }
                    };
                }
            }
            finally {
                if (null == in) {
                    response.close();
                }
            }
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        long length;
        block8: {
            oracle.dbtools.util.Logger.info(this.getClass(), (String)target);
            length = in.available();
            try {
                CloudStorageUrl csUrl = this.getTargetUrl(null == target ? null : Paths.get(target, new String[0]));
                csUrl.validateUrlAsObject();
                URL targetUrl = csUrl.getFinalUrlAsOCI();
                FilterInputStream inw = new InputStreamProgressWrapper(in, progressMonitor, length);
                MessageDigest digest = MD5.getMessageDigest();
                inw = new DigestInputStream(inw, digest);
                if (in instanceof PipedInputStream) {
                    inw = new DynamicInputStreamWrapper((InputStream)inw);
                }
                OCIRequest request = new OCIRequest.Builder().host(targetUrl.getHost()).method("put").target(targetUrl.getPath()).inputStream((InputStream)inw).build();
                try (CloseableHttpResponse response = this.client.getResponse(request);){
                    if (200 == response.getCode()) {
                        String md5Received;
                        String md5Promised = new String(Base64.getEncoder().encodeToString(digest.digest()));
                        Header md5Header = response.getFirstHeader("opc-content-md5");
                        String string = md5Received = null == md5Header ? null : md5Header.getValue();
                        if (!md5Promised.equals(md5Received)) {
                            throw new TransferException(TransferMessages.format("Oci_MD5_CHECK_FAILED", md5Promised, md5Received));
                        }
                        oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                        break block8;
                    }
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
            }
            catch (Throwable t) {
                throw OracleOciStorageLocation.asIOException(t);
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String qualifier) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)qualifier);
        try {
            CloudStorageUrl csUrl = this.getTargetUrl(qualifier);
            csUrl.validateUrlAsObject();
            URL targetUrl = csUrl.getFinalUrlAsOCI();
            OCIRequest request = new OCIRequest.Builder().host(targetUrl.getHost()).method("delete").target(targetUrl.getPath()).build();
            try (CloseableHttpResponse response = this.client.getResponse(request);){
                if (204 != response.getCode()) {
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
            }
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    @Override
    public List<Map<?, ?>> list(String type, String target) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)target);
        try {
            String t = null;
            CloudStorageUrl csUrl = this.getTargetUrl(t);
            URL targetUrl = csUrl.getFinalUrlAsOCI();
            String host = "";
            Object path = "";
            String id = null;
            List<Map<?, ?>> clist = null;
            switch (type) {
                case "b": {
                    host = csUrl.getHostAsID();
                    id = this.client.getTenancyId();
                    if (target != null && !target.isEmpty()) {
                        path = "/20160918/compartments/?compartmentId=" + id;
                        id = null;
                        clist = this.reqList(host, (String)path);
                        if (clist != null) {
                            for (int i = 0; i < clist.size(); ++i) {
                                Map<?, ?> entry = clist.get(i);
                                if (!((String)entry.get("name")).equals(target)) continue;
                                id = (String)entry.get("id");
                                break;
                            }
                        }
                        if (id == null) {
                            return null;
                        }
                    }
                    if (!targetUrl.toString().endsWith("/b/") && !(targetUrl = csUrl.getNamespaceUrlAsOCI()).toString().endsWith("/b/")) {
                        targetUrl = new URL(targetUrl.toString() + "/b/");
                    }
                    host = targetUrl.getHost();
                    path = targetUrl.getPath() + "?compartmentId=" + id;
                    break;
                }
                case "c": {
                    host = csUrl.getHostAsID();
                    id = this.client.getTenancyId();
                    if (target != null) {
                        path = "/20160918/compartments/?compartmentId=" + id;
                        clist = this.reqList(host, (String)path);
                        if (clist != null) {
                            for (int i = 0; i < clist.size(); ++i) {
                                Map<?, ?> entry = clist.get(i);
                                if (!((String)entry.get("name")).equals(target)) continue;
                                id = (String)entry.get("id");
                                break;
                            }
                        }
                        if (id == null) {
                            return null;
                        }
                        path = "/20160918/compartments/?compartmentId=" + id;
                        break;
                    }
                    path = "/20160918/compartments/?compartmentId=" + id + "&compartmentIdInSubtree=true";
                    break;
                }
                case "o": {
                    csUrl.validateUrlAsBucket();
                    if (!targetUrl.toString().endsWith("/o/")) {
                        targetUrl = new URL(targetUrl.toString() + "/o/");
                    }
                    host = targetUrl.getHost();
                    path = targetUrl.getPath();
                    break;
                }
                default: {
                    return null;
                }
            }
            return this.reqList(host, (String)path);
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Map<?, ?>> reqList(String host, String path) throws IOException {
        try {
            OCIRequest request = new OCIRequest.Builder().host(host).method("get").target(path).build();
            try (CloseableHttpResponse response = this.client.getResponse(request);){
                String ct;
                if (200 != response.getCode()) {
                    throw new IOException(String.valueOf(response.getReasonPhrase()));
                }
                HttpEntity ent = response.getEntity();
                String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType() : "application/octect";
                if (ct.equals("application/json")) {
                    List<Map<?, ?>> list = response != null && response.getEntity() != null ? this.mapList(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8")) : null;
                    return list;
                }
                List<Map<?, ?>> list = null;
                return list;
            }
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    private List<Map<?, ?>> mapList(String jsonString) throws Exception {
        Map objectsMap = Collections.emptyMap();
        if (jsonString == null) {
            return Collections.emptyList();
        }
        if (!jsonString.startsWith(this.pre)) {
            StringBuffer obj = new StringBuffer();
            obj.append(this.pre);
            obj.append(jsonString);
            obj.append(this.post);
            jsonString = obj.toString();
        }
        if ((objectsMap = JSON.std.mapFrom((Object)jsonString)) != null && !objectsMap.isEmpty()) {
            List listMap = (List)objectsMap.get("objects");
            return listMap;
        }
        return Collections.emptyList();
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        return super.logExecuteScript(tagName, executeScriptStr, scriptName, targetDir);
    }

    @Override
    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        return super.executeScript(executeScriptStr, scriptName, targetDir);
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        return super.getMd5(path, offset, size);
    }

    @Override
    public String toString() {
        String url = this.storageUrl.toString();
        try {
            url = String.valueOf(this.storageUrl.getFinalUrl());
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.ignore(this.getClass(), (Throwable)t);
        }
        return this.profile + "@" + url + " " + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return super.doPreProcessing(transferId, fileInfos, targetDir);
    }

    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        super.doPostProcessing(transferId, fileInfos, targetDir);
    }

    public static void main(String[] args) {
        OracleOciStorageLocation.setUpLogging();
        RunnableTimer.time(clazz.getCanonicalName(), () -> {
            OracleOciStorageLocation storage = null;
            try {
                CloudStorageUrl csUrl = new CloudStorageUrl(NAMESPACE_URL);
                storage = new OracleOciStorageLocation(csUrl, PROFILE);
                storage.connect();
                storage.test();
            }
            catch (Throwable t) {
                oracle.dbtools.util.Logger.severe(clazz, (Throwable)t);
            }
            finally {
                if (storage != null) {
                    storage.disconnect();
                }
                RaptorTaskManager.getInstance().shutdown();
            }
        });
        if (DUMMY) {
            OracleOciStorageLocation storage = new OracleOciStorageLocation(null, "");
            storage.test();
        }
    }

    public static void setUpLogging() {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %4$-6s %2$s %5$s%6$s%n");
        StreamHandler handler = new StreamHandler(System.err, new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                return Thread.currentThread().toString() + " " + super.format(record);
            }
        }){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        handler.setLevel(Level.ALL);
        Logger.getGlobal().addHandler(handler);
        if (LOG_APACHE_HTTP) {
            Logger.getLogger("org.apache.http").addHandler(handler);
            Logger.getLogger("org.apache.http").setLevel(Level.FINEST);
            Logger.getLogger("org.apache.http").setUseParentHandlers(false);
        }
    }

    private void test() {
        try {
            RunnableTimer.time("testGetTargetUrl", () -> {
                try {
                    this.testGetTargetUrl(null);
                }
                catch (Throwable t) {
                    oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
                }
            });
            RunnableTimer.time("testRoundTripIO", () -> {
                try {
                    this.testRoundTripIO(BUCKET);
                }
                catch (Throwable t) {
                    oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
                }
            });
            RunnableTimer.time("testAsOutputStream", () -> {
                try {
                    this.testAsOutputStream(BUCKET);
                }
                catch (Throwable t) {
                    oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
                }
            });
            RunnableTimer.time("testObjectNameReservation", () -> {
                try {
                    this.testObjectNameReservation(BUCKET);
                }
                catch (Throwable t) {
                    oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
                }
            });
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    public static String dateTime() {
        return simpleDateFormat.format(new Date());
    }

    private void testGetTargetUrl(String bucketName) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)("testGetTargetUrl " + bucketName));
        CloudStorageUrl holdStorageUrl = this.storageUrl;
        try {
            IOException failedException = null;
            String format = "%s Testing [%s] %5s, %s == %s ?";
            CloudStorageUrl bucketCsu = new CloudStorageUrl(NAMESPACE_URL + BUCKET);
            URL bucketUrl = bucketCsu.getFinalUrlAsOCI();
            ArrayList<Pair> bucketTests = new ArrayList<Pair>();
            bucketTests.add(new Pair((Object)BUCKET, (Object)true));
            bucketTests.add(new Pair((Object)"b/brian", (Object)false));
            bucketTests.add(new Pair((Object)"/brian", (Object)false));
            bucketTests.add(new Pair((Object)"brian", (Object)true));
            bucketTests.add(new Pair((Object)"\\b\\brian", (Object)true));
            bucketTests.add(new Pair((Object)"b\\brian", (Object)false));
            bucketTests.add(new Pair((Object)"\\brian", (Object)false));
            for (Pair test : bucketTests) {
                Path path = Paths.get((String)test.first(), new String[0]);
                URL testUrl = this.getTargetUrl(path).getFinalUrlAsOCI();
                if (((Boolean)test.second()).booleanValue() == bucketUrl.equals(testUrl)) {
                    oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format(format, "PASSED", test.first(), test.second(), bucketUrl, testUrl));
                    continue;
                }
                String msg = String.format(format, "FAILED", test.first(), test.second(), bucketUrl, testUrl);
                if (null == failedException) {
                    failedException = new IOException(msg);
                }
                oracle.dbtools.util.Logger.info(this.getClass(), (String)msg);
            }
            this.storageUrl = bucketCsu;
            URL objectUrl = new CloudStorageUrl(NAMESPACE_URL + BUCKET + OBJECT).getFinalUrlAsOCI();
            ArrayList<Pair> objectTests = new ArrayList<Pair>();
            objectTests.add(new Pair((Object)OBJECT, (Object)true));
            objectTests.add(new Pair((Object)"o/test.object", (Object)false));
            objectTests.add(new Pair((Object)"/test.object", (Object)false));
            objectTests.add(new Pair((Object)"test.object", (Object)true));
            objectTests.add(new Pair((Object)"\\o\\test.object", (Object)true));
            objectTests.add(new Pair((Object)"o\\test.object", (Object)false));
            objectTests.add(new Pair((Object)"\\test.object", (Object)false));
            for (Pair test : objectTests) {
                Path path = Paths.get((String)test.first(), new String[0]);
                URL testUrl = this.getTargetUrl(path).getFinalUrlAsOCI();
                if (((Boolean)test.second()).booleanValue() == objectUrl.equals(testUrl)) {
                    oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format(format, "PASSED", test.first(), test.second(), bucketUrl, testUrl));
                    continue;
                }
                String msg = String.format(format, "FAILED", test.first(), test.second(), bucketUrl, testUrl);
                if (null == failedException) {
                    failedException = new IOException(msg);
                }
                oracle.dbtools.util.Logger.info(this.getClass(), (String)msg);
            }
            if (failedException != null) {
                throw failedException;
            }
            oracle.dbtools.util.Logger.info(this.getClass(), (String)"testGetTargetUrl - PASSED");
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (String)"testGetTargetUrl - FAILED");
            throw OracleOciStorageLocation.asIOException(t);
        }
        finally {
            this.storageUrl = holdStorageUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAsOutputStream(String bucketName) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)("testAsOutputStream " + bucketName));
        try {
            File file = File.createTempFile("testAsOutputStream", ".stream");
            String objectName = file.getName();
            file.delete();
            String targetAsString = bucketName + "/o/" + objectName;
            Path targetAsPath = Paths.get(bucketName, OBJECTS, objectName);
            StoreAndForwardStorageLocation.UserTaskListener listener = new StoreAndForwardStorageLocation.UserTaskListener();
            OutputStream os = this.asOutputStream(targetAsPath, listener);
            MessageDigest digestOut = MD5.getMessageDigest();
            os = new DigestOutputStream(os, digestOut);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), StandardCharsets.UTF_8);
            for (int i = 1; i < this.OUTPUT_STREAM_MESSAGE_COUNT + 1; ++i) {
                Thread.sleep(1000L);
                out.write(String.format("%s testAsOutputStream - %d\n", OracleOciStorageLocation.dateTime(), i));
                ((Writer)out).flush();
            }
            ((Writer)out).close();
            listener.waitForDone();
            if (listener.getThrowable() != null) {
                throw listener.getThrowable();
            }
            InputStream in = this.asInputStream(Paths.get(bucketName, OBJECTS, objectName), 0L, 0L, new SimpleByteProgressMonitor());
            MessageDigest digestIn = MD5.getMessageDigest();
            in = new DigestInputStream(in, digestIn);
            try (OutputStream os1 = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                }
            };){
                int l;
                byte[] buffer = new byte[4096];
                while ((l = in.read(buffer)) != -1) {
                    os1.write(buffer, 0, l);
                }
                os1.flush();
            }
            finally {
                in.close();
            }
            this.delete(targetAsString);
            String md5Out = new String(Base64.getEncoder().encodeToString(digestOut.digest()));
            String md5In = new String(Base64.getEncoder().encodeToString(digestIn.digest()));
            if (!md5In.equals(md5Out)) {
                throw new IOException(String.format("\n\tMD5 %s\n\t!=  %s", md5Out, md5In));
            }
            oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format("MD5 %s == %s", md5Out, md5In));
            oracle.dbtools.util.Logger.info(this.getClass(), (String)"testAsOutputStream - PASSED");
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (String)"testAsOutputStream - FAILED");
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    private void testRoundTripIO(String bucketName) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)("testRoundTripIO " + bucketName));
        try {
            File file = File.createTempFile("testRoundTripIO", ".pangram");
            String objectName = file.getName();
            file.delete();
            String out = "The wizard quickly jinxed the gnomes before they vaporized";
            ByteArrayInputStream source = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
            String target = bucketName + "/o/" + objectName;
            this.copy(source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            Path path = Paths.get(bucketName, OBJECTS, objectName);
            if (!this.exists(path)) {
                throw new IOException(String.valueOf(path) + " does not exist after create");
            }
            InputStream in = this.asInputStream(path, 0L, 0L, new SimpleByteProgressMonitor());
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    sb.append((char)c);
                }
            }
            int position = 19;
            int size = 17;
            String outr = out.substring(position, position + size);
            InputStream inr = this.asInputStream(path, position, size, new SimpleByteProgressMonitor());
            StringBuilder sbr = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inr, StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    sbr.append((char)c);
                }
            }
            if (!outr.equals(sbr.toString())) {
                throw new IOException(String.format("Ranged retrieval failed. '%s' != '%s'", outr, sbr.toString()));
            }
            this.delete(target);
            if (this.exists(path)) {
                throw new IOException(String.valueOf(path) + " exists after delete");
            }
            if (out.equals(sb.toString())) {
                oracle.dbtools.util.Logger.info(this.getClass(), (String)"testRoundTripIO - PASSED");
            } else {
                oracle.dbtools.util.Logger.warn(this.getClass(), (String)"testRoundTripIO - FAILED");
            }
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (String)("testRoundTripIO - FAILED " + String.valueOf(t)));
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Path path) throws IOException {
        boolean exists = false;
        try {
            CloudStorageUrl target = this.getTargetUrl(path);
            target.validateUrlAsObject();
            URL targetUrl = target.getFinalUrlAsOCI();
            OCIRequest request = new OCIRequest.Builder().host(targetUrl.getHost()).method("head").target(targetUrl.getPath()).build();
            try (CloseableHttpResponse response = this.client.getResponse(request);){
                if (200 == response.getCode()) {
                    exists = true;
                }
            }
            oracle.dbtools.util.Logger.info(this.getClass(), (String)String.format("%s %s", exists, targetUrl));
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
        return exists;
    }

    private void testObjectNameReservation(String bucketName) throws IOException {
        oracle.dbtools.util.Logger.info(this.getClass(), (String)("testObjectNameReservation " + bucketName));
        try {
            File file = File.createTempFile("testObjectNameReservation", ".piped");
            String objectName = file.getName();
            file.delete();
            final String content = OracleOciStorageLocation.fileToString(filePath1);
            String target = bucketName + "/o/" + objectName;
            Path path = Paths.get(bucketName, OBJECTS, objectName);
            StoreAndForwardStorageLocation.UserTaskListener listener = null;
            if (RESERVE_NAME) {
                listener = new StoreAndForwardStorageLocation.UserTaskListener();
                OutputStreamWriter reserve = new OutputStreamWriter(this.asOutputStream(path, listener), StandardCharsets.UTF_8);
                ((Writer)reserve).write(120);
                ((Writer)reserve).close();
                listener.waitForDone();
                if (listener.getThrowable() != null) {
                    throw OracleOciStorageLocation.asIOException(listener.getThrowable());
                }
                if (!this.exists(path)) {
                    throw new IOException(String.valueOf(path) + " does not exist after create");
                }
            }
            listener = new StoreAndForwardStorageLocation.UserTaskListener();
            final OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.asOutputStream(path, listener)), StandardCharsets.UTF_8);
            if (RESERVE_NAME && !this.exists(path)) {
                throw new IOException(String.valueOf(path) + " does not exist after new asOutputStream");
            }
            String name = "testObjectNameReservation Data->PIPE task";
            RaptorTask<Void> task = new RaptorTask<Void>(name, true, IRaptorTaskRunMode.NO_GUI){

                protected Void doWork() throws TaskException {
                    try {
                        int beginIndex = 0;
                        int length = content.length();
                        int endIndex = length / OracleOciStorageLocation.this.OUTPUT_STREAM_MESSAGE_COUNT;
                        while (beginIndex < length) {
                            Thread.sleep(500L);
                            String batch = content.substring(beginIndex, endIndex);
                            beginIndex += batch.length();
                            endIndex += batch.length();
                            out.write(batch);
                            out.flush();
                        }
                        out.close();
                    }
                    catch (Throwable t) {
                        if (t instanceof TaskException) {
                            throw (TaskException)t;
                        }
                        throw new TaskException(t);
                    }
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)task);
            listener.waitForDone();
            if (listener.getThrowable() != null) {
                throw listener.getThrowable();
            }
            if (!this.exists(path)) {
                throw new IOException(String.valueOf(path) + " does not exist after create");
            }
            InputStream in = this.asInputStream(path, 0L, 0L, new SimpleByteProgressMonitor());
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    sb.append((char)c);
                }
            }
            this.delete(target);
            if (this.exists(path)) {
                throw new IOException(String.valueOf(path) + " exists after delete");
            }
            if (content.equals(sb.toString())) {
                oracle.dbtools.util.Logger.info(this.getClass(), (String)"testObjectNamereservation - PASSED");
            } else {
                oracle.dbtools.util.Logger.warn(this.getClass(), (String)"testObjectNamereservation1 - FAILED");
            }
        }
        catch (Throwable t) {
            throw OracleOciStorageLocation.asIOException(t);
        }
    }

    private static String fileToString(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFileRoundTripIO(String filePath) {
        String tag = "testFileRoundTripIO(" + filePath + ")";
        oracle.dbtools.util.Logger.info(this.getClass(), (String)tag);
        try {
            String bucketName = BUCKET;
            File file = new File(filePath);
            String objectName = this.getClass().getSimpleName() + "-" + file.getName();
            FileInputStream source = new FileInputStream(file);
            String target = bucketName + "/o/" + objectName;
            long start = System.nanoTime();
            this.copy(source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            long now = System.nanoTime();
            long duration = now - start;
            double elapsed = (double)duration / 1.0E9;
            oracle.dbtools.util.Logger.info(this.getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
            start = System.nanoTime();
            try (InputStream in = this.asInputStream(Paths.get(bucketName, OBJECTS, objectName), 0L, 0L, new SimpleByteProgressMonitor());
                 FileOutputStream os = new FileOutputStream(filePath + "-" + this.getClass().getSimpleName());){
                int l;
                byte[] buffer = new byte[4096];
                while ((l = in.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, l);
                }
                os.flush();
            }
            now = System.nanoTime();
            duration = now - start;
            elapsed = (double)duration / 1.0E9;
            oracle.dbtools.util.Logger.info(this.getClass(), (String)(file.getName() + " Download Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    private void testManagedFileRoundTripIO(final String filePath) {
        String tag = "testManagedFileRoundTripIO(" + filePath + ")";
        oracle.dbtools.util.Logger.info(this.getClass(), (String)tag);
        try {
            final String bucketName = BUCKET;
            FileSet fileSet = new FileSet(Location.getLocal(), Collections.emptySet());
            fileSet.add(filePath);
            TransferTask transferTask = TransferManager.INSTANCE.createTransferTask(tag, IRaptorTaskRunMode.NO_GUI, fileSet, this, bucketName);
            final long start = System.nanoTime();
            final File file = new File(filePath);
            MD5 md5 = new MD5();
            final String md5Promised = new String(Base64.getEncoder().encodeToString(md5.getHashBytes(filePath, "MD5")));
            this.taskDone = false;
            transferTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent event) {
                    oracle.dbtools.util.Logger.severe(((Object)((Object)this)).getClass(), (Throwable)event.getThrowable());
                    OracleOciStorageLocation.this.taskDone = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(RaptorTaskEvent event) {
                    try {
                        long now = System.nanoTime();
                        long duration = now - start;
                        double elapsed = (double)duration / 1.0E9;
                        oracle.dbtools.util.Logger.info(((Object)((Object)this)).getClass(), (String)(file.getName() + " Upload Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
                        InputStream in = OracleOciStorageLocation.this.asInputStream(Paths.get(bucketName, file.getName()), 0L, 0L, new SimpleByteProgressMonitor());
                        MessageDigest md5MessageDigest = MD5.getMessageDigest();
                        in = new DigestInputStream(in, md5MessageDigest);
                        try (FileOutputStream os = new FileOutputStream(filePath + "-" + clazz.getSimpleName());){
                            int l;
                            byte[] buffer = new byte[4096];
                            while ((l = in.read(buffer)) != -1) {
                                ((OutputStream)os).write(buffer, 0, l);
                            }
                            os.flush();
                        }
                        finally {
                            in.close();
                        }
                        String md5Received = new String(Base64.getEncoder().encodeToString(md5MessageDigest.digest()));
                        if (!md5Promised.equals(md5Received)) {
                            oracle.dbtools.util.Logger.severe(clazz, (String)String.format("\n\tMD5 %s\n\t!=  %s", md5Promised, md5Received));
                        } else {
                            oracle.dbtools.util.Logger.info(clazz, (String)String.format("MD5 %s == %s", md5Promised, md5Received));
                        }
                        now = System.nanoTime();
                        duration = now - start;
                        elapsed = (double)duration / 1.0E9;
                        oracle.dbtools.util.Logger.info(((Object)((Object)this)).getClass(), (String)(file.getName() + " Download Elapsed = " + df.format(elapsed) + "s [" + RunnableTimer.asHMSS(duration) + "]\n"));
                    }
                    catch (Throwable t) {
                        oracle.dbtools.util.Logger.severe(((Object)((Object)this)).getClass(), (Throwable)t);
                    }
                    finally {
                        OracleOciStorageLocation.this.taskDone = true;
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)transferTask);
            try {
                while (!this.taskDone) {
                    Thread.sleep(250L);
                }
            }
            catch (Throwable t) {
                oracle.dbtools.util.Logger.severe(this.getClass(), (String)tag, (Throwable)t);
            }
        }
        catch (Throwable t) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)t);
        }
    }

    static {
        NAMESPACE_URL = "https://objectstorage.us-phoenix-1.oraclecloud.com/n/oraclefreedb";
        PROFILE = "freedb";
        BUCKET = "/b/brian";
        OBJECT = "/o/test.object";
        LOG_APACHE_HTTP = false;
        filePath1 = "/Users/bjeffrie/SHARED/test/employees.csv";
        simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        RESERVE_NAME = true;
        df = new DecimalFormat("#00.0000");
    }
}

