/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import org.apache.sshd.client.session.ClientSession;

public final class HostConnection {
    private ClientSession mSession;
    private final HostDescriptor mDescriptor;
    private final Client mClient;
    private Map<String, Tunnel> mTunnels = new HashMap<String, Tunnel>();

    HostConnection(Client client, ClientSession session, HostDescriptor desc) {
        this.mClient = client;
        this.mSession = session;
        this.mDescriptor = desc;
    }

    public HostDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public ClientSession getSession() {
        return this.mSession;
    }

    public boolean isConnected() {
        return this.mSession != null && this.mSession.isOpen();
    }

    void disconnect() {
        try {
            for (Tunnel t : this.mTunnels.values()) {
                try {
                    t.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mClient.fireTunnelClosed(t);
            }
            this.mTunnels.clear();
            this.mSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mSession = null;
    }

    Tunnel openTunnel(TunnelDescriptor desc) throws IOException {
        if (this.mSession == null) {
            throw new IOException("Closed Session", new IllegalStateException("Closed Session"));
        }
        String name = desc.getName();
        Tunnel tunnel = this.mTunnels.get(name);
        if (tunnel == null) {
            tunnel = new Tunnel(this, desc);
            tunnel.connect();
            this.mClient.fireTunnelOpened(tunnel);
            this.mTunnels.put(name, tunnel);
        }
        return tunnel;
    }

    boolean isTunnelOpen(TunnelDescriptor desc) {
        return this.mTunnels.containsKey(desc.getName());
    }

    void closeTunnel(TunnelDescriptor desc) throws IOException {
        String name = desc.getName();
        Tunnel tunnel = this.mTunnels.remove(name);
        if (tunnel != null) {
            tunnel.disconnect();
            this.mClient.fireTunnelClosed(tunnel);
        }
    }
}

