/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.bastion.model.SessionLifecycleState;
import com.oracle.bmc.bastion.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSessionsRequest
extends BmcRequest<Void> {
    private String bastionId;
    private String opcRequestId;
    private String displayName;
    private SessionLifecycleState sessionLifecycleState;
    private String sessionId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public String getBastionId() {
        return this.bastionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SessionLifecycleState getSessionLifecycleState() {
        return this.sessionLifecycleState;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().bastionId(this.bastionId).opcRequestId(this.opcRequestId).displayName(this.displayName).sessionLifecycleState(this.sessionLifecycleState).sessionId(this.sessionId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bastionId=").append(String.valueOf(this.bastionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",sessionLifecycleState=").append(String.valueOf((Object)this.sessionLifecycleState));
        sb.append(",sessionId=").append(String.valueOf(this.sessionId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSessionsRequest)) {
            return false;
        }
        ListSessionsRequest other = (ListSessionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bastionId, other.bastionId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.sessionLifecycleState, (Object)other.sessionLifecycleState) && Objects.equals(this.sessionId, other.sessionId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bastionId == null ? 43 : this.bastionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.sessionLifecycleState == null ? 43 : this.sessionLifecycleState.hashCode());
        result = result * 59 + (this.sessionId == null ? 43 : this.sessionId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSessionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bastionId = null;
        private String opcRequestId = null;
        private String displayName = null;
        private SessionLifecycleState sessionLifecycleState = null;
        private String sessionId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder bastionId(String bastionId) {
            this.bastionId = bastionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sessionLifecycleState(SessionLifecycleState sessionLifecycleState) {
            this.sessionLifecycleState = sessionLifecycleState;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSessionsRequest o) {
            this.bastionId(o.getBastionId());
            this.opcRequestId(o.getOpcRequestId());
            this.displayName(o.getDisplayName());
            this.sessionLifecycleState(o.getSessionLifecycleState());
            this.sessionId(o.getSessionId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSessionsRequest build() {
            ListSessionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSessionsRequest buildWithoutInvocationCallback() {
            ListSessionsRequest request = new ListSessionsRequest();
            request.bastionId = this.bastionId;
            request.opcRequestId = this.opcRequestId;
            request.displayName = this.displayName;
            request.sessionLifecycleState = this.sessionLifecycleState;
            request.sessionId = this.sessionId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

