/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.sqlcl.commands.dg.DgOpTable;
import oracle.dbtools.sqlcl.commands.dg.DgResult;
import oracle.dbtools.sqlcl.commands.dg.DgValue;
import org.w3c.dom.Document;

public class DgXmlObject {
    public Document xmlDocument;
    protected static final Logger LOGGER = Logger.getLogger(DgXmlObject.class.getName());

    public DgXmlObject(Document doc) {
        this.xmlDocument = doc;
    }

    public static Document parse(String doc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(doc.getBytes("UTF-8"));
            return builder.parse(input);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }

    public static DgXmlObject create(String doc) {
        Document xmlDoc;
        DgXmlObject ret = null;
        if (doc != null && (xmlDoc = DgXmlObject.parse(doc)) != null) {
            String root = xmlDoc.getDocumentElement().getTagName();
            if ("RESULT".equalsIgnoreCase(root)) {
                ret = new DgResult(xmlDoc);
            } else if ("TABLE".equalsIgnoreCase(root)) {
                ret = new DgOpTable(xmlDoc);
            } else if ("VALUE".equalsIgnoreCase(root)) {
                ret = new DgValue(xmlDoc);
            } else {
                LOGGER.info("Unknown xml document: " + root);
            }
        }
        if (ret == null) {
            LOGGER.info("parse error: " + doc);
        }
        return ret;
    }

    public String getName() {
        return this.xmlDocument.getDocumentElement().getTagName();
    }
}

