/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowRecoveryServiceSubnetWorkflow
extends Workflow {
    private String compartmentId;
    private String recoveryServiceSubnetId;
    private String recoveryServiceSubnetName;
    private ZRCVClientManager zrcvClientManager;

    public ShowRecoveryServiceSubnetWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("show recovery_service_subnet", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new ShowRecoveryServiceSubnet());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        Connection conn = this.getConnection();
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.recoveryServiceSubnetName = (String)command.getOptionValue((Id)RCVOptions.Options.NAME);
        this.recoveryServiceSubnetId = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        if (this.compartmentId == null) {
            ProtectedDatabaseMetadata metadata = RCVCommand.getProtectedDatabaseMetadata(DatabaseUtils.getDbUniqueName(conn));
            if (metadata.getCompartmentId() == null) {
                throw new IllegalArgumentException("Failed to get protection policies. Please provide a compartment ID!");
            }
            this.compartmentId = metadata.getCompartmentId();
        }
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(this.getLogger());
    }

    private ListRecoveryServiceSubnetsRequest createListRecoveryServiceSubnetsRequest() {
        ListRecoveryServiceSubnetsRequest.Builder requestBuilder = ListRecoveryServiceSubnetsRequest.builder();
        requestBuilder = requestBuilder.compartmentId(this.compartmentId);
        if (this.recoveryServiceSubnetName != null) {
            requestBuilder.displayName(this.recoveryServiceSubnetName);
        }
        return requestBuilder.build();
    }

    private class ShowRecoveryServiceSubnet
    implements UnitOfWork {
        private ShowRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            Logger logger = ShowRecoveryServiceSubnetWorkflow.this.getLogger();
            if (ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetName != null && ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId != null) {
                String error = String.format("Please only provide either %s or %s", new Object[]{RCVOptions.Options.NAME, RCVOptions.Options.SUBNET_ID});
                return new Result(Status.FAILED, error);
            }
            if (ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId != null) {
                GetRecoveryServiceSubnetRequest request = GetRecoveryServiceSubnetRequest.builder().recoveryServiceSubnetId(ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId).build();
                RecoveryServiceSubnet subnet = ShowRecoveryServiceSubnetWorkflow.this.zrcvClientManager.getRecoveryServiceSubnet(request);
                if (subnet != null) {
                    logger.log(Level.INFO, "Display Name:            " + subnet.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + subnet.getId());
                } else {
                    logger.log(Level.INFO, "No recovery service subnet found.");
                }
                return new Result(Status.SUCCESS);
            }
            ListRecoveryServiceSubnetsRequest request = ShowRecoveryServiceSubnetWorkflow.this.createListRecoveryServiceSubnetsRequest();
            List<RecoveryServiceSubnetSummary> summaryList = ShowRecoveryServiceSubnetWorkflow.this.zrcvClientManager.getRecoveryServiceSubnets(request);
            if (summaryList.size() > 0) {
                for (RecoveryServiceSubnetSummary summary : summaryList) {
                    logger.log(Level.INFO, "Display Name:            " + summary.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + summary.getId());
                    logger.log(Level.INFO, "\n");
                }
            } else {
                logger.log(Level.INFO, "No recovery service subnets found for compartment " + ShowRecoveryServiceSubnetWorkflow.this.compartmentId);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

