/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowProtectionPolicyWorkflow
extends ProtectedDatabaseWorkflow {
    private String compartmentId;
    private String protectionPolicyName;
    private String protectionPolicyId;
    private ZRCVClientManager zrcvClientManager;

    public ShowProtectionPolicyWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("show protection_policy", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new ShowProtectionPolicy());
        super.setSteps(steps);
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.protectionPolicyName = (String)command.getOptionValue((Id)RCVOptions.Options.NAME);
        this.protectionPolicyId = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        if (this.compartmentId == null) {
            ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
            if (metadata.getCompartmentId() == null) {
                throw new IllegalArgumentException("Failed to get protection policies. Please provide a compartment ID!");
            }
            this.compartmentId = metadata.getCompartmentId();
        }
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(this.getLogger());
    }

    private class ShowProtectionPolicy
    implements UnitOfWork {
        private ShowProtectionPolicy() {
        }

        @Override
        public Result run() {
            Logger logger = ShowProtectionPolicyWorkflow.this.getLogger();
            List<Object> summaryList = new ArrayList();
            if (ShowProtectionPolicyWorkflow.this.protectionPolicyName != null && ShowProtectionPolicyWorkflow.this.protectionPolicyId != null) {
                String error = String.format("Please only provide either %s or %s", new Object[]{RCVOptions.Options.PROTECTION_POLICY_NAME, RCVOptions.Options.PROTECTION_POLICY_ID});
                return new Result(Status.FAILED, error);
            }
            if (ShowProtectionPolicyWorkflow.this.protectionPolicyName == null && ShowProtectionPolicyWorkflow.this.protectionPolicyId == null) {
                summaryList = ShowProtectionPolicyWorkflow.this.zrcvClientManager.getProtectionPolicies(ShowProtectionPolicyWorkflow.this.compartmentId);
            } else if (ShowProtectionPolicyWorkflow.this.protectionPolicyName != null) {
                summaryList = ShowProtectionPolicyWorkflow.this.zrcvClientManager.getProtectionPoliciesByName(ShowProtectionPolicyWorkflow.this.protectionPolicyName, ShowProtectionPolicyWorkflow.this.compartmentId);
            } else if (ShowProtectionPolicyWorkflow.this.protectionPolicyId != null) {
                ProtectionPolicy policy = ShowProtectionPolicyWorkflow.this.zrcvClientManager.getProtectionPolicy(ShowProtectionPolicyWorkflow.this.protectionPolicyId, ShowProtectionPolicyWorkflow.this.compartmentId);
                if (policy == null) {
                    logger.log(Level.INFO, "No protection policy found.");
                } else {
                    logger.log(Level.INFO, "Display Name:            " + policy.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + policy.getId());
                    logger.log(Level.INFO, "Backup Retention Period: " + policy.getBackupRetentionPeriodInDays() + " days");
                }
                return new Result(Status.SUCCESS);
            }
            if (summaryList.size() > 0) {
                for (ProtectionPolicySummary protectionPolicySummary : summaryList) {
                    logger.log(Level.INFO, "Display Name:            " + protectionPolicySummary.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + protectionPolicySummary.getId());
                    logger.log(Level.INFO, "Backup Retention Period: " + protectionPolicySummary.getBackupRetentionPeriodInDays() + " days");
                    logger.log(Level.INFO, "\n");
                }
            } else {
                logger.log(Level.INFO, "No protection policies found for compartment " + ShowProtectionPolicyWorkflow.this.compartmentId);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

