/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.controllers.FleetEngine;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowBackupConfigWorkflow
extends ProtectedDatabaseWorkflow {
    private Connection fleetEngineConn;

    public ShowBackupConfigWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("show backup_config", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new GetBackupConfigValues());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        Logger logger = this.getLogger();
        try {
            this.fleetEngineConn = FleetEngine.getEngineConnection(metadata);
        }
        catch (SQLException e) {
            String error = "Failed to connect to Command Engine";
            logger.log(Level.SEVERE, error, e);
            throw new RuntimeException(error + ": " + e.getMessage());
        }
    }

    public class GetBackupConfigValues
    implements UnitOfWork {
        @Override
        public Result run() {
            String CONFIGURATION_NAME = "configuration_name";
            String CONFIGURATION_VALUE = "configuration_value";
            String GET_CONFIG_SQL = String.format("select %s, %s from ra_ce_site_config order by %s", "configuration_name", "configuration_value", "configuration_name");
            Logger logger = ShowBackupConfigWorkflow.this.getLogger();
            try {
                ResultSet rs = DBUtil.getInstance((Connection)ShowBackupConfigWorkflow.this.fleetEngineConn).executeOracleQuery(GET_CONFIG_SQL, null);
                ArrayList lads = new ArrayList();
                while (rs.next()) {
                    String name = rs.getString("configuration_name");
                    String value = rs.getString("configuration_value");
                    logger.log(Level.INFO, String.format("Config Name:  %s", name));
                    logger.log(Level.INFO, String.format("Config Value: %s\n", value));
                }
                rs.close();
            }
            catch (SQLException e) {
                String error = "Failed to get config from Command Engine: " + e.getMessage();
                logger.log(Level.SEVERE, error, e);
                return new Result(Status.FAILED, error);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

