/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ProtectedDatabaseWorkflow
extends Workflow {
    private String dbUniqueName;
    private ProtectedDatabaseMetadata metadata;

    public ProtectedDatabaseWorkflow(String name, ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(name, command, conn, ctx);
        this.dbUniqueName = RCVCommand.getDbUniqueName(conn);
        this.metadata = RCVCommand.getProtectedDatabaseMetadata(this.dbUniqueName);
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public ProtectedDatabaseMetadata getProtectedDatabaseMetadata() {
        return this.metadata;
    }

    public String getProtectedDatabaseOcid() {
        ZRCVClientManager zrcvClientManager;
        String ocid = this.metadata.getOcid();
        if ((ocid == null || ocid.length() == 0) && (ocid = (zrcvClientManager = RCVCommand.createZrcvClientManager()).getProtectedDatabaseOcid(this.getConnection())) != null) {
            this.metadata.setOcid(ocid);
        }
        return ocid;
    }

    public boolean isProtectedDatabaseOnboarded() {
        return this.getProtectedDatabaseOcid() != null;
    }

    @Override
    public boolean isApplicable() {
        if (!this.isProtectedDatabaseOnboarded()) {
            Result result = Result.databaseNotOnboarded(String.format("Database %s is not onboarded to ZRCV.", this.dbUniqueName));
            super.logResult(result);
            return false;
        }
        return true;
    }

    public void saveMetadata() {
        this.metadata.save();
    }
}

