/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.TnsnamesHelper;
import oracle.dbtools.extension.rcv.controllers.ConfigurationManager;
import oracle.dbtools.extension.rcv.controllers.WalletManager;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.Sqlnet;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.UpdateProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.utils.TNSHelper;

public class EnableRealtimeRedoWorkflow
extends ProtectedDatabaseWorkflow {
    private LogArchiveConfig currentLogArchiveConfig;
    private LogArchiveConfig targetLogArchiveConfig;
    private HashMap<Integer, LogArchiveDestination> currentDestinations;
    private List<LogArchiveDestination> targetDestinations;
    private ProtectedDatabase protectedDatabase;
    private boolean restartDatabase = false;
    private ZRCVClientManager zrcvClientManager;
    private String walletRoot;

    public EnableRealtimeRedoWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("enable realtime_redo", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new RunChecks());
        steps.add(new ConfigureWallet());
        steps.add(new ConfigureTnsNames());
        steps.add(new ConfigureSqlnet());
        steps.add(new VerifyConnection());
        steps.add(new VerifyBackupsExist());
        steps.add(new ConfigureLogArchiveDestinations());
        steps.add(new ConfigureRedoTransportUser());
        steps.add(new NotifyControlPlane());
        steps.add(new RestartDatabase());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        Optional<ParsedCommand> updateZRCVConfigurationCommand;
        UpdateZRCVConfigurationWorkflow wf;
        Result updateConfigResult;
        Connection conn = this.getConnection();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        Logger logger = this.getLogger();
        ScriptRunnerContext ctx = this.getContext();
        String rcvConf = ConfigurationManager.getRcvConf(metadata);
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
        String dgConfigString = DatabaseUtils.getLogArchiveConfig(conn);
        this.currentLogArchiveConfig = new LogArchiveConfig();
        if (dgConfigString != null) {
            this.currentLogArchiveConfig = new LogArchiveConfig(dgConfigString);
        }
        if ((updateConfigResult = (wf = new UpdateZRCVConfigurationWorkflow((updateZRCVConfigurationCommand = Workflow.generateParsedCommand(RCVVerbs.UPDATE, RCVObjects.ZRCV_CONFIG, null, null, ctx)).get(), this.getConnection(), this.getContext())).run()).getStatus().equals((Object)Status.FAILED)) {
            String error = updateConfigResult.getMessage() != null ? updateConfigResult.getMessage() : "";
            throw Result.errInitUpdateException("Failed to update client configuration! " + error);
        }
        this.targetDestinations = new ArrayList<LogArchiveDestination>();
        try {
            this.targetLogArchiveConfig = new LogArchiveConfig(ConfigurationManager.getLogArchiveConfig(rcvConf));
        }
        catch (IOException e) {
            throw Result.errInitLogConfigException("Failed to get log archive config from RCV conf: " + e.getMessage());
        }
        try {
            this.targetDestinations = ConfigurationManager.getLogArchiveDestinationGroups(rcvConf);
        }
        catch (IOException e) {
            throw Result.errInitLogDestException("Failed to get log archive destination groups from RCV conf: " + e.getMessage());
        }
        try {
            this.currentDestinations = this.getLogArchiveDestinationsByDestinationName(this.targetLogArchiveConfig.getDgConfig());
        }
        catch (SQLException e) {
            throw Result.errInitLogDestDbException("Failed to retrieve log archive destinations from database: " + e.getMessage());
        }
        this.protectedDatabase = this.zrcvClientManager.getProtectedDatabase(metadata.getOcid());
        this.walletRoot = WalletManager.getWalletRoot(conn);
    }

    private HashMap<Integer, LogArchiveDestination> getLogArchiveDestinationsByDestinationName(List<String> destinationNames) throws SQLException {
        Connection conn = this.getConnection();
        ResultSet rs = DatabaseUtils.getLogArchiveDestinations(conn, destinationNames);
        ArrayList<String> logArchiveDestinationParameters = new ArrayList<String>();
        HashMap<Integer, LogArchiveDestination> destinations = new HashMap<Integer, LogArchiveDestination>();
        if (rs != null) {
            while (rs.next()) {
                int destId = rs.getInt("DEST_ID");
                logArchiveDestinationParameters.add("log_archive_dest_" + destId);
            }
            HashMap<String, String> logArchiveDestinationMap = DatabaseUtils.getParameters(conn, logArchiveDestinationParameters);
            for (String parameterName : logArchiveDestinationMap.keySet()) {
                String destinationValue = logArchiveDestinationMap.get(parameterName);
                int i = (parameterName = parameterName.trim()).lastIndexOf("_");
                if (i == -1) continue;
                int id = Integer.parseInt(parameterName.substring(i + 1));
                destinations.put(id, LogArchiveDestination.createInstance(destinationValue));
            }
        }
        return destinations;
    }

    private List<String> getMissingDgConfig() {
        ArrayList<String> missing = new ArrayList<String>();
        for (String targetDest : this.targetLogArchiveConfig.getDgConfig()) {
            boolean found = false;
            for (String currentDest : this.currentLogArchiveConfig.getDgConfig()) {
                if (!currentDest.equalsIgnoreCase(targetDest)) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(targetDest);
        }
        return missing;
    }

    private boolean isZRCVInLogArchiveConfig() {
        for (String targetDest : this.targetLogArchiveConfig.getDgConfig()) {
            boolean found = false;
            for (String currentDest : this.currentLogArchiveConfig.getDgConfig()) {
                if (!currentDest.equalsIgnoreCase(targetDest)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private class RunChecks
    implements UnitOfWork {
        private RunChecks() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Run prechecks");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            Connection conn = EnableRealtimeRedoWorkflow.this.getConnection();
            if (DatabaseUtils.isPDB(conn)) {
                String error = "You are connected to a PDB. This command requires a CDB connection to run. Please reconnect to the CDB and rerun this command.";
                return Result.errCheckPdbError(error);
            }
            String currentUser = DatabaseUtils.getRedoTransportUser(conn);
            if (currentUser != null && !currentUser.equals("null") && currentUser.trim().length() > 0 && !currentUser.equals(EnableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName())) {
                String error = "The REDO_TRANSPORT_USER is not empty and does not match the VPC username. Please verify it is empty and rerun this command.";
                return Result.errCheckRedoUserError(error);
            }
            if (EnableRealtimeRedoWorkflow.this.walletRoot == null || EnableRealtimeRedoWorkflow.this.walletRoot.length() == 0 || EnableRealtimeRedoWorkflow.this.walletRoot.equals("null") || !Files.exists(Paths.get(EnableRealtimeRedoWorkflow.this.walletRoot, new String[0]), new LinkOption[0])) {
                String error = "wallet_root is not set up. Please verify wallet_root exists and rerun this command.";
                return Result.errCheckWalletError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureWallet
    implements UnitOfWork {
        private ConfigureWallet() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure wallet");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            try {
                String serverSepsPathString = String.join((CharSequence)File.separator, EnableRealtimeRedoWorkflow.this.walletRoot, "server_seps");
                Path serverSepsPath = Paths.get(serverSepsPathString, new String[0]);
                Path walletLocationPath = Paths.get(metadata.getWalletLocation(), new String[0]);
                if (Files.isSymbolicLink(serverSepsPath)) {
                    if (Files.readSymbolicLink(serverSepsPath).equals(walletLocationPath)) {
                        return new Result(Status.SUCCESS);
                    }
                    String error = serverSepsPathString + " is a symlink but it does not point to the agent's wallet location.";
                    return new Result(Status.FAILED, error);
                }
                Files.createSymbolicLink(serverSepsPath, walletLocationPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String error = String.format("Failed to create symlink wallet_root: %s", e.getMessage());
                return Result.errConfigWalletError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureTnsNames
    implements UnitOfWork {
        private ConfigureTnsNames() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure tnsnames");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            try {
                if (!TnsnamesHelper.updateIfile(metadata.getTnsnamesFile())) {
                    return new Result(Status.SKIPPED);
                }
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
            }
            catch (FileNotFoundException e) {
                return Result.errConfigTnsError("Failed to check and update tnsnames.ora: " + e.getMessage());
            }
            catch (IOException e) {
                return Result.errConfigTnsError("Failed to check and update tnsnames.ora: " + e.getMessage());
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureSqlnet
    implements UnitOfWork {
        private ConfigureSqlnet() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure sqlnet");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            Sqlnet sqlnet = new Sqlnet(Sqlnet.getSqlnetOraPath().toString());
            try {
                if (!sqlnet.addIfile(metadata.getSqlnetFile())) {
                    return new Result(Status.SKIPPED);
                }
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
                sqlnet.writeFile();
            }
            catch (FileNotFoundException e) {
                return Result.errConfigSqlError("Failed to check and update sqlnet.ora: " + e.getMessage());
            }
            catch (IOException e) {
                return Result.errConfigSqlError("Failed to check and update sqlnet.ora: " + e.getMessage());
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class VerifyConnection
    implements UnitOfWork {
        private VerifyConnection() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Verify connection to recovery service");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            System.setProperty("oracle.net.wallet_location", metadata.getWalletLocation());
            System.setProperty("oracle.net.tns_admin", TNSHelper.getOracleHome() + File.separator + "network" + File.separator + "admin");
            for (LogArchiveDestination dest : EnableRealtimeRedoWorkflow.this.targetDestinations) {
                String url = "jdbc:oracle:thin:@" + dest.getService();
                try {
                    DriverManager.getConnection(url);
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "Failed to establish connection to service " + dest.getService());
                    return Result.errVerifyDbConnectionError(e.getMessage());
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class VerifyBackupsExist
    implements UnitOfWork {
        private VerifyBackupsExist() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Check backups");
            String healthDetails = EnableRealtimeRedoWorkflow.this.protectedDatabase.getHealthDetails();
            if (healthDetails.startsWith("No backups available")) {
                return Result.errVerifyBackupExistsError("No backups exist. Please run 'rcv backup protected_database' to take a backup before enabling realtime redo.");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureLogArchiveDestinations
    implements UnitOfWork {
        private ConfigureLogArchiveDestinations() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure log archive destinations");
            Connection conn = EnableRealtimeRedoWorkflow.this.getConnection();
            List<Object> freeDestinations = new ArrayList();
            int freeDestinationIndex = 0;
            HashMap<String, String> updatedParameters = new HashMap<String, String>();
            try {
                freeDestinations = DatabaseUtils.getFreeLogArchiveDestinations(conn);
            }
            catch (SQLException e) {
                return Result.errConfLogDestFreeError("Failed to get free log archive destinations: " + e.getMessage());
            }
            ArrayList<Integer> destinationIds = new ArrayList<Integer>();
            for (LogArchiveDestination targetDest : EnableRealtimeRedoWorkflow.this.targetDestinations) {
                String string = targetDest.getDbUniqueName();
                String targetDestService = targetDest.getService();
                boolean foundTarget = false;
                for (int id : EnableRealtimeRedoWorkflow.this.currentDestinations.keySet()) {
                    LogArchiveDestination currentDest = EnableRealtimeRedoWorkflow.this.currentDestinations.get(id);
                    String currentDestDbUniqueName = currentDest.getDbUniqueName();
                    String currentDestService = currentDest.getService();
                    if (!currentDestDbUniqueName.equalsIgnoreCase(string) || !currentDestService.equalsIgnoreCase(targetDestService)) continue;
                    foundTarget = true;
                    destinationIds.add(id);
                    if (targetDest.equals(currentDest)) break;
                    String updateSql = "alter system set log_archive_dest_" + id + " = '" + targetDest.toString() + "'";
                    logger.log(Level.FINE, "The following sql will be executed:");
                    logger.log(Level.FINE, "\t" + updateSql + "\n");
                    updatedParameters.put("log_archive_dest_" + id, targetDest.toString());
                    break;
                }
                if (foundTarget || freeDestinationIndex >= freeDestinations.size()) continue;
                String freeDestination = (String)freeDestinations.get(freeDestinationIndex);
                String sql = String.format("alter system set %s = '%s'", freeDestination, targetDest.toString());
                logger.log(Level.FINE, "The following sql will be executed:");
                logger.log(Level.FINE, "\t" + sql + "\n");
                ++freeDestinationIndex;
                int ui = freeDestination.lastIndexOf("_");
                if (ui >= 0) {
                    destinationIds.add(Integer.parseInt(freeDestination.substring(ui + 1)));
                }
                updatedParameters.put(freeDestination, targetDest.toString());
            }
            HashMap<Object, Object> destinationStates = new HashMap();
            try {
                destinationStates = DatabaseUtils.getLogArchiveDestinationState(conn, destinationIds);
            }
            catch (SQLException e) {
                return Result.errConfLogDestStateError("Failed to get log archive destination states: " + e.getMessage());
            }
            for (String string : destinationStates.keySet()) {
                if (((String)destinationStates.get(string)).equalsIgnoreCase("ENABLE")) continue;
                logger.log(Level.FINE, "The following sql will be executed:");
                String sql = String.format("alter system set parameter %s = '%s'", string, "enable");
                logger.log(Level.FINE, "\t" + sql + "\n");
                updatedParameters.put(string, "enable");
            }
            List<String> missingDgConfig = EnableRealtimeRedoWorkflow.this.getMissingDgConfig();
            if (missingDgConfig.size() > 0) {
                String string = String.format("alter system set log_archive_config = '%s'", EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.toString());
                logger.log(Level.FINE, "The following sql will be executed:");
                logger.log(Level.FINE, "\t" + string);
                List<String> currentDgConfig = EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.getDgConfig();
                for (String missing : missingDgConfig) {
                    currentDgConfig.add(missing);
                }
                updatedParameters.put("log_archive_config", EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.toString());
            }
            if (updatedParameters.keySet().size() > 0) {
                try {
                    DatabaseUtils.updateParameter(conn, updatedParameters);
                }
                catch (SQLException sQLException) {
                    return Result.errConfLogDestUpdateError("Failed to update log archive destinations: " + sQLException.getMessage());
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            EnableRealtimeRedoWorkflow.this.restartDatabase = true;
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureRedoTransportUser
    implements UnitOfWork {
        private ConfigureRedoTransportUser() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure redo transport user");
            ProtectedDatabaseMetadata metadata = EnableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            Connection conn = EnableRealtimeRedoWorkflow.this.getConnection();
            String currentRedoTransportUser = DatabaseUtils.getRedoTransportUser(conn);
            String vpcUser = EnableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName();
            if (currentRedoTransportUser != null && currentRedoTransportUser.equals(vpcUser)) {
                return new Result(Status.SKIPPED);
            }
            if (currentRedoTransportUser != null && !currentRedoTransportUser.equals("null") && currentRedoTransportUser.length() > 0 && !currentRedoTransportUser.equals(vpcUser)) {
                return Result.errConfRedoUserError(String.format("Found an unexpected redo_transport_user %s. Please make sure the redo_transport_user is empty before enabling realtime redo.", currentRedoTransportUser));
            }
            if (currentRedoTransportUser == null || currentRedoTransportUser.equals("null") || currentRedoTransportUser.length() == 0) {
                HashMap<String, String> updatedParameters = new HashMap<String, String>();
                updatedParameters.put("redo_transport_user", vpcUser);
                try {
                    DatabaseUtils.updateParameter(conn, updatedParameters);
                }
                catch (SQLException e) {
                    return Result.errConfRedoUserUpdateError("Failed to update redo_transport_user: " + e.getMessage());
                }
                logger.log(Level.FINE, "The following sql will be executed:");
                logger.log(Level.FINE, String.format("alter system set redo_transport_user='%s'", metadata.getVpcUserName()));
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class NotifyControlPlane
    implements UnitOfWork {
        private NotifyControlPlane() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Notify control plane");
            if (!EnableRealtimeRedoWorkflow.this.protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                Connection conn = EnableRealtimeRedoWorkflow.this.getConnection();
                ScriptRunnerContext ctx = EnableRealtimeRedoWorkflow.this.getContext();
                Optional<ParsedCommand> updateProtectedDatabaseCommand = Workflow.generateParsedCommand(RCVVerbs.UPDATE, RCVObjects.PROTECTED_DATABASE, Map.of(RCVOptions.Options.REALTIME_REDO.toString(), "true"), null, ctx);
                UpdateProtectedDatabaseWorkflow updateProtectedDatabaseWorkflow = new UpdateProtectedDatabaseWorkflow(updateProtectedDatabaseCommand.get(), conn, ctx);
                return updateProtectedDatabaseWorkflow.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RestartDatabase
    implements UnitOfWork {
        private RestartDatabase() {
        }

        @Override
        public Result run() {
            Logger logger = EnableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Check database");
            if (EnableRealtimeRedoWorkflow.this.restartDatabase) {
                logger.log(Level.INFO, "!! Action Required: Please restart the database to finish enabling real-time redo !!");
            }
            return new Result(Status.SUCCESS);
        }
    }
}

