/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.FleetEngine;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.commandengine.ConfigureRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.InitRequest;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureBackupWorkflow
extends ProtectedDatabaseWorkflow {
    private String libraLocation;
    private String encryptionAlgorithm;
    private String preferredBackupSite;
    private boolean diagnosticUpload;
    private int maxChannels;
    private int archivalBackupInterval;
    private String configName;
    private String configValue;
    private int instanceId;
    private Connection fleetEngineConnection;

    public ConfigureBackupWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command, conn, ctx, true);
    }

    public ConfigureBackupWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx, boolean fetchLatestConfig) {
        super("configure protected_database", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        if (fetchLatestConfig) {
            steps.add(new UpdateConfiguration());
        }
        steps.add(new ConfigureBackup());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        this.configName = (String)command.getOptionValue((Id)RCVOptions.Options.CONFIG_NAME);
        this.configValue = (String)command.getOptionValue((Id)RCVOptions.Options.CONFIG_VALUE);
        this.configValue = this.configValue.replaceAll("^\"|\"$", "");
        this.instanceId = DatabaseUtils.getInstanceId(this.getConnection());
        try {
            this.fleetEngineConnection = FleetEngine.getEngineConnection(metadata);
        }
        catch (SQLException e) {
            String error = String.format("Failed to get connection to fleet engine: %s", e.getMessage());
            throw Result.cpdFleetAgentConnectionException(error, e);
        }
        if (this.fleetEngineConnection == null) {
            throw Result.cpdFleetAgentConnectionException("Failed to get connection to fleet engine!", null);
        }
    }

    private class UpdateConfiguration
    implements UnitOfWork {
        private UpdateConfiguration() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureBackupWorkflow.this.getLogger();
            ScriptRunnerContext ctx = ConfigureBackupWorkflow.this.getContext();
            Optional<ParsedCommand> updateZRCVConfigurationCommand = Workflow.generateParsedCommand(RCVVerbs.UPDATE, RCVObjects.ZRCV_CONFIG, null, null, ctx);
            UpdateZRCVConfigurationWorkflow wf = new UpdateZRCVConfigurationWorkflow(updateZRCVConfigurationCommand.get(), ConfigureBackupWorkflow.this.getConnection(), ConfigureBackupWorkflow.this.getContext());
            return wf.run();
        }
    }

    private class ConfigureBackup
    implements UnitOfWork {
        private ConfigureBackup() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureBackupWorkflow.this.getLogger();
            String dbUniqueName = ConfigureBackupWorkflow.this.getDbUniqueName();
            try {
                InitRequest initRequest = new InitRequest.Builder(ConfigureBackupWorkflow.this.fleetEngineConnection, dbUniqueName.toUpperCase(), ConfigureBackupWorkflow.this.instanceId).build();
                FleetEngineResponse response = FleetEngine.retry(2, initRequest);
                FleetEngineResponse.Status status = response.getStatus();
                if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                    return new Result(Status.FAILED, response.getMessage());
                }
                if (response.getData() == null) {
                    return new Result(Status.FAILED, "Failed to initiate connection with Command Engine!");
                }
                int agentId = (Integer)response.getData();
                ConfigureRequest configureRequest = new ConfigureRequest.Builder(ConfigureBackupWorkflow.this.fleetEngineConnection, dbUniqueName, agentId, ConfigureBackupWorkflow.this.configName, ConfigureBackupWorkflow.this.configValue).build();
                status = (response = configureRequest.execute()).getStatus();
                if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                    String responseMessage = response.getMessage();
                    String error = String.format("Failed to update protected database settings: %s %s", new Object[]{status, responseMessage == null ? "" : responseMessage});
                    return new Result(Status.FAILED, error);
                }
            }
            catch (SQLException e) {
                logger.log(Level.FINE, Utils.getStackTrace(e));
                String error = String.format("Failed to update protected database configuration: %s", e.getMessage());
                return Result.cpdUpdateError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

