/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.check.Checks;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ChecksWorkflow
extends Workflow {
    public ChecksWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("run checks", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new RunChecks());
        super.setSteps(steps);
    }

    private class RunChecks
    implements UnitOfWork {
        private RunChecks() {
        }

        @Override
        public Result run() {
            Logger logger = ChecksWorkflow.this.getLogger();
            List<Check> checks = Checks.getChecks(Group.ALL, ChecksWorkflow.this.getConnection(), false);
            CheckResult checkResult = Checks.runChecks(checks, logger);
            if (checkResult.getStatus().equals((Object)CheckResult.Status.PASS)) {
                return new Result(Status.SUCCESS);
            }
            return Result.chwChecksError(checkResult.getMessage());
        }
    }
}

