/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.recovery.model.CreateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.model.WorkRequestResource;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.check.Checks;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.SshHelper;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.BackupManager;
import oracle.dbtools.extension.rcv.controllers.ConfigurationManager;
import oracle.dbtools.extension.rcv.controllers.WalletManager;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.SystemCommand;
import oracle.dbtools.extension.rcv.models.VpcUser;
import oracle.dbtools.extension.rcv.rest.OCIClientManager;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ConfigureBackupWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleSecretStoreException;

public class AddProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private ZRCVClientManager zrcvClientManager;
    private String endpoint;
    private String compartmentId;
    private String protectionPolicyId;
    private List<RecoveryServiceSubnetInput> recoverySubnets = new ArrayList<RecoveryServiceSubnetInput>();
    private String password;
    private String libraLocation;
    private boolean realtimeRedo;
    private ProtectedDatabase protectedDatabase;
    private boolean onboarded;
    private static final String DBRS = "DBRS";
    private int instanceId;
    private boolean isOCI;
    private final boolean dryRun;
    private static GlobalMetadata globalMetadata = GlobalMetadata.load();

    public AddProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("add protected database", command, conn, ctx);
        Result optionsCheck = this.checkOptions();
        if (optionsCheck.getStatus().equals((Object)Status.FAILED)) {
            throw new IllegalArgumentException(optionsCheck.getMessage());
        }
        this.dryRun = command.isFlagSet((Id)RCVOptions.Options.VALIDATE);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new RunChecks());
        steps.add(new CheckProtectedDatabaseExistence());
        steps.add(new OnboardProtectedDatabaseToControlPlane());
        if (!this.dryRun) {
            steps.add(new StorePassword());
            steps.add(new VerifyLifeCycleState());
            steps.add(new UpdateConfiguration());
            steps.add(new RegisterDatabaseWithRMAN());
            steps.add(new ConfigureProtectedDatabase());
            steps.add(new SaveMetadata());
            steps.add(new CopyMetadataToRemoteNodes());
        }
        super.setSteps(steps);
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public Result checkOptions() {
        ParsedCommand command = this.getCommand();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        String protectionPolicyId = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_ID);
        String protectionPolicyName = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_NAME);
        String libraLocation = (String)command.getOptionValue((Id)RCVOptions.Options.SBT_LIBRARY);
        if (protectionPolicyId == null && protectionPolicyName == null) {
            String error = "Missing required options. Please provide either a protection_policy_name or protection_policy_id.";
            return Result.invalidOption(error);
        }
        if (libraLocation == null && metadata.getLibraLocation() == null) {
            String error = String.format("Missing required options. Please provide %s", new Object[]{RCVOptions.Options.SBT_LIBRARY});
            return Result.invalidOption(error);
        }
        return new Result(Status.SUCCESS);
    }

    @Override
    public void initState() {
        Logger logger = this.getLogger();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        ParsedCommand command = this.getCommand();
        metadata.setCompartmentId((String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID));
        List subnets = (List)command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS);
        this.password = null;
        this.instanceId = DatabaseUtils.getInstanceId(this.getConnection());
        for (Object id : subnets) {
            this.recoverySubnets.add(RecoveryServiceSubnetInput.builder().recoveryServiceSubnetId((String)id).build());
        }
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.protectionPolicyId = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_ID);
        String protectionPolicyName = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_NAME);
        this.libraLocation = (String)command.getOptionValue((Id)RCVOptions.Options.SBT_LIBRARY);
        if (this.endpoint == null) {
            this.endpoint = OCIClientManager.getRecoveryServiceEndpoint();
        }
        if (command.getOptionValue((Id)RCVOptions.Options.REALTIME_REDO) != null) {
            this.realtimeRedo = (Boolean)command.getOptionValue((Id)RCVOptions.Options.REALTIME_REDO);
        }
        if (this.libraLocation != null) {
            metadata.setLibraLocation(this.libraLocation);
        }
        globalMetadata.setRecoveryServiceEndpoint(this.endpoint);
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
        if (metadata.getOcid() != null) {
            this.onboarded = true;
            this.protectedDatabase = this.zrcvClientManager.getProtectedDatabase(metadata.getOcid());
        }
        if (this.protectionPolicyId == null) {
            if (protectionPolicyName == null) {
                Object id;
                id = this.zrcvClientManager.getDefaultProtectionPolicies(this.compartmentId);
            } else {
                List<String> protectionPolicyOcids = this.zrcvClientManager.getProtectionPolicyOcids(protectionPolicyName = protectionPolicyName.replaceAll("^\"|\"$", ""), this.compartmentId);
                if (protectionPolicyOcids.isEmpty()) {
                    String error = String.format("Protection policy %s does not exist. Please provide a valid protection policy name.", protectionPolicyName);
                    throw Result.apdMetadataInitException(error);
                }
                if (protectionPolicyOcids.size() == 1) {
                    this.protectionPolicyId = protectionPolicyOcids.get(0);
                } else {
                    String error = String.format("Found multiple protection policies with the name %s. Please provide an OCID for the desired protection policy using --protection_policy_id <ocid>.", protectionPolicyName);
                    throw Result.apdMetadataInitException(error);
                }
            }
        }
        try {
            metadata.createMetadataDirectory();
        }
        catch (IOException e) {
            throw Result.apdMetadataInitException("Failed to create metadata directory: " + e.getMessage());
        }
        String systemType = globalMetadata.getSystemType();
        this.isOCI = systemType.equals("OCI");
    }

    private String onboardProtectedDatabase(String vpcPassword) {
        Logger logger = this.getLogger();
        CreateProtectedDatabaseDetails createProtectedDatabaseDetails = this.createProtectedDatabaseDetails(vpcPassword);
        CreateProtectedDatabaseResponse response = this.zrcvClientManager.onboardProtectedDatabase(createProtectedDatabaseDetails, this.dryRun);
        String workRequestId = response.getOpcWorkRequestId();
        if (workRequestId != null) {
            logger.log(Level.FINE, "OPC request ID: " + response.getOpcRequestId());
            logger.log(Level.FINE, "OPC Work Request ID: " + workRequestId);
            WorkRequest workRequest = this.zrcvClientManager.getWorkRequest(workRequestId);
            return ((WorkRequestResource)workRequest.getResources().get(0)).getIdentifier();
        }
        return null;
    }

    private CreateProtectedDatabaseDetails createProtectedDatabaseDetails(String vpcPassword) {
        Connection conn = this.getConnection();
        ParsedCommand command = this.getCommand();
        String dbUniqueName = this.getDbUniqueName();
        int dbSize = DatabaseUtils.getDbSize(conn);
        String displayName = dbUniqueName;
        if (command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME) != null) {
            displayName = (String)command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME);
        }
        CreateProtectedDatabaseDetails.Builder builder = CreateProtectedDatabaseDetails.builder().displayName(displayName).dbUniqueName(dbUniqueName).databaseSizeInGBs(Integer.valueOf(dbSize)).password(vpcPassword).protectionPolicyId(this.protectionPolicyId).recoveryServiceSubnets(this.recoverySubnets).compartmentId(this.compartmentId);
        String dbId = null;
        if (this.isOCI) {
            OCIClientManager ociClientManager = new OCIClientManager(globalMetadata.getAuthentication());
            DatabaseSummary dbSummary = ociClientManager.getDatabaseSummary(this.getDbUniqueName());
            if (dbSummary != null) {
                dbId = dbSummary.getId();
            }
        } else {
            dbId = DatabaseUtils.generateDatabaseIdForOnPremiseClient(conn);
        }
        if (dbId != null) {
            builder = builder.databaseId(dbId);
        }
        return builder.build();
    }

    @Override
    public void handleFailure() {
        try {
            this.saveMetadata();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to save database metadata: " + e.getMessage());
        }
        try {
            globalMetadata.save();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to save global metadata: " + e.getMessage());
        }
    }

    private class RunChecks
    implements UnitOfWork {
        private RunChecks() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Run prechecks");
            if (!AddProtectedDatabaseWorkflow.this.onboarded) {
                CheckResult checkResult = Checks.runChecks(Checks.getChecks(Group.ONBOARDING_PRECHECKS, AddProtectedDatabaseWorkflow.this.getConnection(), AddProtectedDatabaseWorkflow.this.realtimeRedo), logger);
                if (checkResult.getStatus().equals((Object)CheckResult.Status.FAIL)) {
                    return Result.apdPrecheckError(checkResult.getMessage());
                }
            } else {
                return new Result(Status.SKIPPED, "Prechecks - Skipped. Database is already onboarded");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class CheckProtectedDatabaseExistence
    implements UnitOfWork {
        private CheckProtectedDatabaseExistence() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Check if protected database exists");
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            if (metadata.getOcid() != null && !metadata.getOcid().isEmpty()) {
                return new Result(Status.SUCCESS);
            }
            String protectedDatabaseOcid = AddProtectedDatabaseWorkflow.this.zrcvClientManager.getProtectedDatabaseOcid(AddProtectedDatabaseWorkflow.this.getConnection());
            if (protectedDatabaseOcid != null) {
                metadata.setOcid(protectedDatabaseOcid);
                AddProtectedDatabaseWorkflow.this.onboarded = true;
                logger.log(Level.FINE, "Protected database already exists. OCID: " + protectedDatabaseOcid);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class OnboardProtectedDatabaseToControlPlane
    implements UnitOfWork {
        private OnboardProtectedDatabaseToControlPlane() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Onboard protected database with recovery service");
            if (!AddProtectedDatabaseWorkflow.this.onboarded) {
                String ocid;
                ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
                AddProtectedDatabaseWorkflow.this.password = new String(Utils.promptAndConfirmPassword("Enter a new password for the VPC user:", "Confirm password:"));
                try {
                    ocid = AddProtectedDatabaseWorkflow.this.onboardProtectedDatabase(AddProtectedDatabaseWorkflow.this.password);
                }
                catch (Exception e) {
                    String error = AddProtectedDatabaseWorkflow.this.dryRun ? "Database is not ready for onboarding: " : "Failed to create protected database.";
                    AddProtectedDatabaseWorkflow.this.logException(e);
                    return Result.apdOnboardDbError(error);
                }
                if (AddProtectedDatabaseWorkflow.this.dryRun) {
                    logger.log(Level.INFO, "Database is ready to be onboarded to Recovery Service.");
                } else {
                    logger.log(Level.FINE, "Created protected database with OCID: " + ocid);
                    metadata.setOcid(ocid);
                    AddProtectedDatabaseWorkflow.this.onboarded = true;
                }
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED, "Onboard Protected Database to Control Plane - Skipped. Database is already onboarded");
        }
    }

    private class StorePassword
    implements UnitOfWork {
        private StorePassword() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Store VPC user password");
            if (!AddProtectedDatabaseWorkflow.this.onboarded) {
                return Result.apdDbNotOnboarded("Failed to store VPC user password - Database is not onboarded.");
            }
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            String ocid = metadata.getOcid();
            ProtectedDatabase protectedDatabase = AddProtectedDatabaseWorkflow.this.zrcvClientManager.getProtectedDatabase(ocid);
            String vpcUserName = protectedDatabase.getVpcUserName();
            metadata.setVpcUserName(vpcUserName);
            String walletLocation = metadata.getWalletLocation();
            try {
                if (!WalletManager.walletContainsUser(WalletManager.createWallet(walletLocation), vpcUserName)) {
                    if (AddProtectedDatabaseWorkflow.this.password == null) {
                        AddProtectedDatabaseWorkflow.this.password = new String(Utils.promptAndConfirmPassword("Enter a new password for the VPC user:", "Confirm password:"));
                    }
                } else {
                    return new Result(Status.SKIPPED);
                }
                VpcUser user = new VpcUser(vpcUserName, AddProtectedDatabaseWorkflow.this.password);
                user.storePassword(walletLocation, AddProtectedDatabaseWorkflow.DBRS);
            }
            catch (IOException | OracleSecretStoreException e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                String error = "Failed to check if VPC credentials are in wallet: " + walletLocation;
                return Result.apdVpcUserWalletError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class VerifyLifeCycleState
    implements UnitOfWork {
        private VerifyLifeCycleState() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Verify lifecycle state");
            if (!AddProtectedDatabaseWorkflow.this.onboarded) {
                return Result.apdDbNotOnboarded("Failed to verify lifecycle state of database - Database is not onboarded.");
            }
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            try {
                AddProtectedDatabaseWorkflow.this.protectedDatabase = AddProtectedDatabaseWorkflow.this.zrcvClientManager.waitForProtectedDatabaseUpdate(metadata.getOcid(), 600, 20);
            }
            catch (Exception e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.apdLifecycleGetStatusError("Failed to get lifecycle state of the protected database");
            }
            LifecycleState lifeCycleState = AddProtectedDatabaseWorkflow.this.protectedDatabase.getLifecycleState();
            if (lifeCycleState.equals((Object)LifecycleState.Creating)) {
                return Result.apdLifecycleStatusTmt("Timed out waiting for protected database to become Active.");
            }
            if (!lifeCycleState.equals((Object)LifecycleState.Active)) {
                String error = String.format("The protected database's state is %s, expected it to be %s or %s", lifeCycleState, LifecycleState.Active, LifecycleState.Creating);
                return Result.apdVerifyLifecycleStatusError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateConfiguration
    implements UnitOfWork {
        private UpdateConfiguration() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Update client configuration");
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            String configZipPath = metadata.getNetworkDirectory() + File.separatorChar + "config.zip";
            String ocid = metadata.getOcid();
            try {
                FetchProtectedDatabaseConfigurationResponse fetchProtectedDatabaseConfigurationResponse = AddProtectedDatabaseWorkflow.this.zrcvClientManager.getConfiguration(ocid, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.All, configZipPath);
            }
            catch (Exception e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.wfGetClientConfError("Failed to fetch protected database configuration.");
            }
            try {
                ConfigurationManager.updateClientConfiguration(configZipPath, metadata);
            }
            catch (Exception e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.wfUpdateClientConfError("Failed to update client configuration.");
            }
            String credentialAlias = AddProtectedDatabaseWorkflow.DBRS;
            String walletLocation = metadata.getWalletLocation();
            try {
                credentialAlias = ConfigurationManager.getCatalogAlias(metadata);
                if (credentialAlias != null) {
                    metadata.setCredentialAlias(credentialAlias);
                } else {
                    logger.log(Level.FINE, "Cannot find alias from ZRCV conf");
                }
            }
            catch (IOException e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.apdGetCatalogAliasError("Failed to get the catalog alias from \"rcv.conf.txt\"");
            }
            if (credentialAlias != null && !credentialAlias.equalsIgnoreCase(AddProtectedDatabaseWorkflow.DBRS)) {
                try {
                    WalletManager.updateAlias(WalletManager.createWallet(walletLocation), AddProtectedDatabaseWorkflow.DBRS, credentialAlias);
                }
                catch (IOException | OracleSecretStoreException e) {
                    AddProtectedDatabaseWorkflow.this.logException(e);
                    return Result.apdUpdateWalletWithAliasError("Failed to update wallet with alias: " + credentialAlias);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class RegisterDatabaseWithRMAN
    implements UnitOfWork {
        private RegisterDatabaseWithRMAN() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Register database with recovery catalog");
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            if (metadata.getVpcUserName() == null) {
                return Result.apdVpcUserMetadataError("Failed to register database with the recovery catalog - Cannot find VPC user from metadata");
            }
            try {
                SystemCommand.ExecutionResult registerResult = BackupManager.registerDatabase(metadata, AddProtectedDatabaseWorkflow.this.getLogger(), false);
                if (registerResult.getReturnCode() != 0) {
                    if (registerResult.getOutput().contains("RMAN-20002")) {
                        return new Result(Status.SKIPPED);
                    }
                    String error = String.format("Failed to register database with the recovery catalog. See %s for more details.", AddProtectedDatabaseWorkflow.this.getLogFile());
                    return Result.apdRegisterDbError(error);
                }
            }
            catch (IOException e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.apdRegisterDbError2("Failed to register database with the recovery catalog.");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureProtectedDatabase
    implements UnitOfWork {
        private ConfigureProtectedDatabase() {
        }

        @Override
        public Result run() {
            Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
            logger.log(Level.INFO, "Configure protected database");
            Connection conn = AddProtectedDatabaseWorkflow.this.getConnection();
            ScriptRunnerContext ctx = AddProtectedDatabaseWorkflow.this.getContext();
            ProtectedDatabaseMetadata metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            Map<String, String> config = Map.of("wallet_location", metadata.getWalletLocation(), "credential_alias", metadata.getCredentialAlias(), "lib_ra_location", metadata.getLibraLocation(), "client_max_channel", "5");
            for (String configName : config.keySet()) {
                Optional<ParsedCommand> configureBackupCommand = Workflow.generateParsedCommand(RCVVerbs.CONFIGURE, RCVObjects.BACKUP, Map.of(RCVOptions.Options.CONFIG_NAME.toString(), configName, RCVOptions.Options.CONFIG_VALUE.toString(), config.get(configName)), null, ctx);
                ConfigureBackupWorkflow configureBackupWorkflow = new ConfigureBackupWorkflow(configureBackupCommand.get(), conn, ctx, false);
                Result configureResult = configureBackupWorkflow.run();
                if (configureResult.getStatus().equals((Object)Status.SUCCESS)) continue;
                return configureResult;
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class SaveMetadata
    implements UnitOfWork {
        private SaveMetadata() {
        }

        @Override
        public Result run() {
            try {
                AddProtectedDatabaseWorkflow.this.saveMetadata();
            }
            catch (Exception e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.apdSaveMetadataError("Failed to save protected database metadata.");
            }
            try {
                globalMetadata.save();
            }
            catch (Exception e) {
                AddProtectedDatabaseWorkflow.this.logException(e);
                return Result.apdSaveMetadataError("Failed to save global metadata.");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class CopyMetadataToRemoteNodes
    implements UnitOfWork {
        private CopyMetadataToRemoteNodes() {
        }

        @Override
        public Result run() {
            String privateKeyFile;
            char[] sshPassword;
            List<String> remoteHostNames;
            ProtectedDatabaseMetadata metadata;
            block18: {
                Logger logger = AddProtectedDatabaseWorkflow.this.getLogger();
                Connection conn = AddProtectedDatabaseWorkflow.this.getConnection();
                logger.log(Level.INFO, "Sync Metadata");
                ScriptRunnerContext ctx = AddProtectedDatabaseWorkflow.this.getContext();
                metadata = AddProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
                try {
                    remoteHostNames = DatabaseUtils.getRemoteHostNames(conn);
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "Failed to get remote hostnames: " + e.getMessage());
                    return new Result(Status.FAILED, "Failed to copy metadata to remote nodes.");
                }
                if (remoteHostNames.isEmpty()) {
                    return new Result(Status.SKIPPED);
                }
                File sshDirectory = new File("/home/oracle/.ssh/");
                FilenameFilter privateKeyFileFilter = (dir, name) -> name.startsWith("id_") && !name.endsWith(".pub") && Files.exists(Paths.get(String.valueOf(sshDirectory) + File.separator + name + ".pub", new String[0]), new LinkOption[0]);
                File[] privateKeyFiles = sshDirectory.listFiles(privateKeyFileFilter);
                sshPassword = null;
                privateKeyFile = null;
                if (privateKeyFiles.length != 1) {
                    Scanner scanner = new Scanner(System.in);
                    Object message = privateKeyFiles.length == 0 ? String.format("Failed to locate SSH key files in %s. ", sshDirectory) : "Found multiple SSH key files. ";
                    message = (String)message + "Please choose one of the following ways to connect to remote node(s).\n1. Password\n2. SSH key\nPlease enter 1 or 2.";
                    while (true) {
                        logger.log(Level.INFO, (String)message);
                        String choice = scanner.nextLine().strip();
                        if (choice.equals("1")) {
                            sshPassword = Utils.promptForPassword("Please enter the oracle SSH password: ");
                            break block18;
                        }
                        if (choice.equals("2")) {
                            while (true) {
                                logger.log(Level.INFO, "Please enter the full path to the oracle SSH private key file: ");
                                privateKeyFile = scanner.nextLine().strip();
                                if (!Files.exists(Paths.get(privateKeyFile, new String[0]), new LinkOption[0])) {
                                    logger.log(Level.INFO, "The file you provided does not exist.");
                                    continue;
                                }
                                break block18;
                                break;
                            }
                        }
                        logger.log(Level.INFO, "Invalid option.");
                    }
                }
                privateKeyFile = String.valueOf(privateKeyFiles[0]);
            }
            for (String hostName : remoteHostNames) {
                SshHelper sshHelper;
                if (sshPassword != null) {
                    sshHelper = new SshHelper("oracle", hostName, 22, null);
                    sshHelper.setPassword(new String(sshPassword));
                } else {
                    sshHelper = new SshHelper("oracle", hostName, 22, privateKeyFile);
                }
                try {
                    sshHelper.connect();
                }
                catch (IOException e) {
                    return new Result(Status.FAILED, "Fail to connect to remote host " + hostName + ": " + e.getMessage());
                }
                ArrayList<File> files = new ArrayList<File>();
                files.add(new File(metadata.getMetadataFile()));
                files.add(new File(metadata.getWalletLocation()));
                while (!files.isEmpty()) {
                    File file = (File)files.remove(0);
                    if (file.isDirectory()) {
                        File[] nestedFiles = file.listFiles();
                        if (nestedFiles == null) continue;
                        Collections.addAll(files, nestedFiles);
                        continue;
                    }
                    try {
                        sshHelper.copy(file.toString(), file.toString());
                    }
                    catch (IOException e) {
                        String error = String.format("Failed to copy %s to %s: %s", file, hostName, e.getMessage());
                        return new Result(Status.FAILED, error);
                    }
                }
                sshHelper.disconnect();
            }
            return new Result(Status.SUCCESS);
        }
    }
}

