/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;

public class NextActionRequest
extends FleetEngineRequest {
    private int agentId;
    private static final String NEXT_ACTION = "call dbms_ra_cmd_engine.next_action(?, ?, ?, ?, ?)";

    private NextActionRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        try {
            CallableStatement cs = super.getCallableStatement();
            cs.setString("P_DB_UNIQUE_NAME", dbUniqueName.toUpperCase());
            cs.setInt("P_AGENT_ID", builder.agentId);
            cs.registerOutParameter("O_ACTION_ID", 4);
            cs.registerOutParameter("O_STATUS_CODE", 4);
            cs.registerOutParameter("O_STATUS_MESG", 12);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get task from Command Engine: " + e.getMessage());
        }
    }

    public int getAgentId() {
        return this.agentId;
    }

    @Override
    public FleetEngineResponse execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int actionId = cs.getInt("O_ACTION_ID");
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESG");
        return new FleetEngineResponse(statusCode, statusMessage, (Object)actionId);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int agentId;

        public Builder(Connection conn, String dbUniqueName, int agentId) {
            super(conn, dbUniqueName, NextActionRequest.NEXT_ACTION);
            this.agentId = agentId;
        }

        @Override
        public NextActionRequest build() {
            return new NextActionRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

