/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.task.Task;

public class GetActionRequest
extends FleetEngineRequest {
    private int agentId;
    private int actionId;
    private static final String GET_ACTION = "call dbms_ra_cmd_engine.get_action(?, ?, ?, ?, ?, ?, ?)";

    private GetActionRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        try {
            this.agentId = builder.agentId;
            this.actionId = builder.actionId;
            CallableStatement cs = super.getCallableStatement();
            cs.setString("P_DB_UNIQUE_NAME", dbUniqueName.toUpperCase());
            cs.setInt("P_AGENT_ID", builder.agentId);
            cs.setInt("P_ACTION_ID", builder.actionId);
            cs.registerOutParameter("O_ACTION_TYPE", 4);
            cs.registerOutParameter("O_CONTENT_SCRIPT", 2005);
            cs.registerOutParameter("O_STATUS_CODE", 4);
            cs.registerOutParameter("O_STATUS_MESG", 12);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get task from Command Engine: " + e.getMessage());
        }
    }

    public int getAgentId() {
        return this.agentId;
    }

    public int getActionId() {
        return this.actionId;
    }

    @Override
    public FleetEngineResponse execute() throws SQLException {
        String dbUniqueName = super.getDbUniqueName();
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESG");
        String scriptsDirectory = RCVCommand.getScriptsDirectory(dbUniqueName);
        String timeStamp = Utils.getTimeStamp();
        String scriptName = String.format("task_%d", this.actionId);
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, scriptName);
        Task task = new Task(this.actionId, cs.getInt("O_ACTION_TYPE"), dbUniqueName, cs.getClob("O_CONTENT_SCRIPT"), scriptPath);
        return new FleetEngineResponse(statusCode, statusMessage, (Object)task);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int agentId;
        private int actionId;

        public Builder(Connection conn, String dbUniqueName, int agentId, int actionId) {
            super(conn, dbUniqueName, GetActionRequest.GET_ACTION);
            this.agentId = agentId;
            this.actionId = actionId;
        }

        @Override
        public GetActionRequest build() {
            return new GetActionRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

