/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.workflows.Result;

public class ProtectedDatabaseMetadata
implements Cloneable {
    private String dbUniqueName;
    private String ocid;
    private String vpcUserName;
    private String credentialAlias;
    private String metadataDirectory;
    private String networkDirectory;
    private String scriptsDirectory;
    private String logsDirectory;
    private String metadataFile;
    private String libraLocation;
    private String walletLocation;
    private String tnsnamesFile;
    private String sqlnetFile;
    private String compartmentId;

    private ProtectedDatabaseMetadata(Builder builder) {
        this.dbUniqueName = builder.dbUniqueName;
        this.ocid = builder.ocid;
        this.vpcUserName = builder.vpcUserName;
        this.credentialAlias = builder.credentialAlias;
        this.compartmentId = builder.compartmentId;
        if (builder.libraLocation != null) {
            this.libraLocation = builder.libraLocation;
        }
    }

    public static ProtectedDatabaseMetadata load(String file, String dbUniqueName) throws IOException {
        JsonObject jsonObject;
        File f = new File(file);
        try (FileInputStream fileStream = new FileInputStream(f);
             JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
            jsonObject = jsonReader.readObject();
        }
        catch (Exception e) {
            String error = String.format("Failed to load protected database metadata from \"%s\" file.", file);
            throw Result.pdbMetadataLoadException(error, e);
        }
        Builder builder = new Builder(dbUniqueName);
        if (jsonObject.containsKey((Object)"dbUniqueName")) {
            builder = new Builder(jsonObject.getString("dbUniqueName"));
        }
        if (jsonObject.containsKey((Object)"ocid")) {
            builder.ocid(jsonObject.getString("ocid"));
        }
        if (jsonObject.containsKey((Object)"compartmentId")) {
            builder.compartmentId(jsonObject.getString("compartmentId"));
        }
        if (jsonObject.containsKey((Object)"vpcUserName")) {
            builder.vpcUserName(jsonObject.getString("vpcUserName"));
        }
        if (jsonObject.containsKey((Object)"libraLocation")) {
            builder.libraLocation(jsonObject.getString("libraLocation"));
        }
        if (jsonObject.containsKey((Object)"credentialAlias")) {
            builder.credentialAlias(jsonObject.getString("credentialAlias"));
        }
        return builder.build();
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVpcUserName() {
        return this.vpcUserName;
    }

    public String getCredentialAlias() {
        return this.credentialAlias;
    }

    public String getNetworkDirectory() {
        if (this.networkDirectory == null) {
            this.networkDirectory = RCVCommand.getNetworkDirectory(this.dbUniqueName);
        }
        return this.networkDirectory;
    }

    public String getLogsDirectory() {
        if (this.logsDirectory == null) {
            this.logsDirectory = RCVCommand.getLogDirectory(this.dbUniqueName);
        }
        return this.logsDirectory;
    }

    public String getMetadataFile() {
        if (this.metadataFile == null) {
            this.metadataFile = RCVCommand.getMetadataPath(this.dbUniqueName);
        }
        return this.metadataFile;
    }

    public String getWalletLocation() {
        if (this.walletLocation == null) {
            this.walletLocation = RCVCommand.getWalletDirectory(this.dbUniqueName);
        }
        return this.walletLocation;
    }

    public String getLibraLocation() {
        String defaultLocation;
        String oracleHome;
        if (this.libraLocation == null && (oracleHome = RCVCommand.getOracleHome()) != null && Files.exists(Paths.get(defaultLocation = RCVCommand.getOracleHome() + File.separatorChar + "lib" + File.separatorChar + "libra.so", new String[0]), new LinkOption[0])) {
            this.libraLocation = defaultLocation;
        }
        return this.libraLocation;
    }

    public String getScriptsDirectory() {
        if (this.scriptsDirectory == null) {
            this.scriptsDirectory = RCVCommand.getScriptsDirectory(this.dbUniqueName);
        }
        return this.scriptsDirectory;
    }

    public String getMetadataDirectory() {
        if (this.metadataDirectory == null) {
            this.metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(this.dbUniqueName);
        }
        return this.metadataDirectory;
    }

    public String getTnsnamesFile() {
        if (this.tnsnamesFile == null) {
            this.tnsnamesFile = String.join((CharSequence)File.separator, this.getNetworkDirectory(), "tnsnames.ora");
        }
        return this.tnsnamesFile;
    }

    public String getSqlnetFile() {
        if (this.sqlnetFile == null) {
            this.sqlnetFile = String.join((CharSequence)File.separator, this.getNetworkDirectory(), "sqlnet.ora");
        }
        return this.sqlnetFile;
    }

    public void setVpcUserName(String name) {
        this.vpcUserName = name;
    }

    public void setOcid(String ocid) {
        this.ocid = ocid;
    }

    public void setCompartmentId(String compartmentId) {
        this.compartmentId = compartmentId;
    }

    public void setCredentialAlias(String alias) {
        this.credentialAlias = alias;
    }

    public void setLibraLocation(String location) {
        this.libraLocation = location;
    }

    public void createMetadataDirectory() throws IOException {
        String[] directories;
        for (String d : directories = new String[]{this.getMetadataDirectory(), this.getNetworkDirectory(), this.getWalletLocation(), this.getScriptsDirectory(), this.getLogsDirectory()}) {
            if (Files.exists(Paths.get(d, new String[0]), new LinkOption[0])) continue;
            Files.createDirectories(Paths.get(d, new String[0]), new FileAttribute[0]);
        }
    }

    public void save() {
        JsonObjectBuilder builder = Json.createObjectBuilder().add("dbUniqueName", this.dbUniqueName);
        if (this.ocid != null) {
            builder.add("ocid", this.ocid);
        }
        if (this.compartmentId != null) {
            builder.add("compartmentId", this.compartmentId);
        }
        if (this.credentialAlias != null) {
            builder.add("credentialAlias", this.credentialAlias);
        }
        if (this.vpcUserName != null) {
            builder.add("vpcUserName", this.vpcUserName);
        }
        if (this.libraLocation != null) {
            builder.add("libraLocation", this.libraLocation);
        }
        File f = new File(this.getMetadataFile());
        try (JsonWriter writer = Json.createWriter((OutputStream)new FileOutputStream(f));){
            writer.writeObject(builder.build());
        }
        catch (Exception e) {
            String error = String.format("Failed to save protected database metadata to \"%s\" file.", this.metadataFile);
            throw Result.pdbMetadataSaveException(error, e);
        }
    }

    public ProtectedDatabaseMetadata clone() {
        try {
            return (ProtectedDatabaseMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class Builder {
        private String dbUniqueName;
        private String ocid;
        private String vpcUserName;
        private String credentialAlias;
        private String libraLocation;
        private String compartmentId;

        public Builder(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder vpcUserName(String name) {
            this.vpcUserName = name;
            return this;
        }

        public Builder credentialAlias(String alias) {
            this.credentialAlias = alias;
            return this;
        }

        public Builder libraLocation(String location) {
            this.libraLocation = location;
            return this;
        }

        public ProtectedDatabaseMetadata build() {
            return new ProtectedDatabaseMetadata(this);
        }
    }
}

