/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.util.ArrayList;
import java.util.List;

public class Node<K, V> {
    private K key;
    private V value;
    private List<Node<K, V>> children;
    private Node<K, V> parent;

    public Node(K key, V val) {
        this.key = key;
        this.value = val;
        this.children = new ArrayList<Node<K, V>>();
        this.parent = null;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public List<Node<K, V>> children() {
        return this.children;
    }

    public List<Node<K, V>> getAll(K targetKey) {
        ArrayList<Node<K, V>> targetNodes = new ArrayList<Node<K, V>>();
        if (this.key.equals(targetKey)) {
            targetNodes.add(this);
        }
        if (this.children == null) {
            return targetNodes;
        }
        for (Node<K, V> n : this.children) {
            List<Node<K, V>> nodes = n.getAll(targetKey);
            for (Node<K, V> targetNode : nodes) {
                targetNodes.add(targetNode);
            }
        }
        return targetNodes;
    }

    public Node<K, V> get(K targetKey) {
        if (this.key.equals(targetKey)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        for (Node<K, V> n : this.children) {
            Node<K, V> targetNode = n.get(targetKey);
            if (targetNode == null) continue;
            return targetNode;
        }
        return null;
    }

    public void setParent(Node<K, V> p) {
        this.parent = p;
    }

    public void setChildren(List<Node<K, V>> children) {
        for (Node<K, V> child : children) {
            child.parent = this;
        }
        this.children = children;
    }

    public Node<K, V> parent() {
        return this.parent;
    }

    public void setValue(V val) {
        this.value = val;
    }

    public void addChild(Node<K, V> child) {
        child.parent = this;
        this.children.add(child);
    }

    public void removeChild(K key) {
        for (Node<K, V> child : this.children) {
            if (!child.key().equals(key)) continue;
            this.children.remove(child);
        }
    }

    public Node<K, V> remove(K key) {
        for (Node<K, V> child : this.children) {
            if (child.key().equals(key)) {
                this.children.remove(child);
                return child;
            }
            Node<K, V> n = child.remove(key);
            if (n == null) continue;
            return n;
        }
        return null;
    }
}

