/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class Config {
    private Properties properties = new Properties();
    private File file;

    public Config(String configFilePath) {
        this.file = new File(configFilePath);
        if (this.file.exists()) {
            try {
                FileReader reader = new FileReader(configFilePath);
                this.properties.load(reader);
            }
            catch (FileNotFoundException reader) {
            }
            catch (IOException e) {
                System.out.println("IO Exception: " + e.getMessage());
            }
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void writeConfig(String comment) {
        try {
            this.properties.store(new FileWriter(this.file), comment);
        }
        catch (IOException e) {
            System.out.println("IO Exception: " + e.getMessage());
        }
    }
}

