/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.io.IOException;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.rest.OCIClientManager;

public class GlobalMetadataManager {
    private static GlobalMetadata globalMetadata = GlobalMetadata.load();

    public static GlobalMetadata getGlobalMetadata() {
        return globalMetadata;
    }

    public static String getRecoveryServiceEndpoint() {
        return globalMetadata.getRecoveryServiceEndpoint();
    }

    public static String getDbSystemOcid() {
        String dbSystemOcid = globalMetadata.getDbSystemOcid();
        if (dbSystemOcid == null && GlobalMetadataManager.getSystemType().equals("OCI")) {
            try {
                dbSystemOcid = OCIClientManager.getDbSystemOcid();
            }
            catch (IOException | InterruptedException e) {
                return null;
            }
            globalMetadata.setDbSystemOcid(dbSystemOcid);
        }
        return dbSystemOcid;
    }

    public static String getSystemType() {
        String systemType = globalMetadata.getSystemType();
        if (systemType == null) {
            boolean isOCI = OCIClientManager.amIInOCI();
            if (isOCI) {
                globalMetadata.setSystemType("OCI");
            } else {
                globalMetadata.setSystemType("ON_PREMISES");
            }
        }
        return globalMetadata.getSystemType();
    }

    public static OCIAuthentication getAuthentication() {
        return globalMetadata.getAuthentication();
    }
}

