/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.ConfigurationManager;
import oracle.dbtools.extension.rcv.controllers.RMANScriptFactory;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.RMANCommand;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.SystemCommand;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;

public class BackupManager {
    private static final String REGISTER_SCRIPT = "register.rman";
    private static final String INCREMENTAL_BACKUP_SCRIPT = "incremental_backup.rman";
    private static final String BACKUP_ARCHIVED_REDO_LOG_SCRIPT = "backup_archived_redo_logs.rman";
    private static final String BACKUP_CONTROLFILE_SCRIPT = "backup_controlfile.rman";
    private static final String BACKUP_SPFILE_SCRIPT = "backup_spfile.rman";

    public static SystemCommand.ExecutionResult registerDatabase(ProtectedDatabaseMetadata metadata, Logger logger, boolean checkConfig) throws IOException {
        RMANScript rmanScript = RMANScriptFactory.generateRegisterDatabaseScript(metadata.getScriptsDirectory());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).tnsAdmin(metadata.getNetworkDirectory()).logger(logger).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult takeIncrementalBackup(ProtectedDatabaseMetadata metadata, String logFile, boolean checkConfig) throws IOException {
        if (checkConfig) {
            ZRCVClientManager zrcvClientManager = RCVCommand.createZrcvClientManager();
            String configZipPath = metadata.getNetworkDirectory() + File.separatorChar + "config.zip";
            zrcvClientManager.getConfiguration(metadata.getOcid(), FetchProtectedDatabaseConfigurationDetails.ConfigurationType.All, configZipPath);
            try {
                ConfigurationManager.updateClientConfiguration(configZipPath, metadata);
            }
            catch (FileNotFoundException e) {
                System.out.println("Encountered error while updating client configuration: " + e.getMessage());
            }
        }
        RMANScript rmanScript = RMANScriptFactory.generateIncrementalBackupScript(metadata.getScriptsDirectory(), 2);
        Map<String, String> backupScriptArgs = Map.of("1", metadata.getLibraLocation().toString(), "2", metadata.getWalletLocation(), "3", metadata.getCredentialAlias(), "4", BackupManager.generateBackupTag());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).logFile(logFile).append(true).tnsAdmin(metadata.getNetworkDirectory()).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupArchivedRedoLogs(ProtectedDatabaseMetadata metadata, String logFile, boolean checkConfig) throws IOException {
        RMANScript rmanScript = RMANScriptFactory.generateArchivedRedoLogsBackupScript(metadata.getScriptsDirectory());
        Map<String, String> backupScriptArgs = Map.of("1", metadata.getLibraLocation().toString(), "2", metadata.getWalletLocation(), "3", metadata.getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).tnsAdmin(metadata.getNetworkDirectory()).logFile(logFile).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupSpfile(ProtectedDatabaseMetadata metadata, String logFile, boolean checkConfig) throws IOException {
        if (checkConfig) {
            // empty if block
        }
        RMANScript rmanScript = RMANScriptFactory.generateSpfileBackupScript(metadata.getScriptsDirectory());
        Map<String, String> backupScriptArgs = Map.of("1", metadata.getLibraLocation().toString(), "2", metadata.getWalletLocation(), "3", metadata.getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).tnsAdmin(metadata.getNetworkDirectory()).logFile(logFile).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupControlFile(ProtectedDatabaseMetadata metadata, String logFile, boolean checkConfig) throws IOException {
        RMANScript rmanScript = RMANScriptFactory.generateControlFileBackupScript(metadata.getScriptsDirectory());
        Map<String, String> backupScriptArgs = Map.of("1", metadata.getLibraLocation().toString(), "2", metadata.getWalletLocation(), "3", metadata.getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).logFile(logFile).tnsAdmin(metadata.getNetworkDirectory()).append(true).build();
        return rmanCommand.execute();
    }

    public static String generateBackupTag() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String timestamp = now.format(formatter);
        return String.format("rcv-incremental-%s.%s", timestamp, Utils.generateRandomString(3));
    }
}

