/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.common;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.Sqlnet;
import oracle.dbtools.extension.rcv.models.SystemCommand;

public class Utils {
    public static void copyFileContent(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        Utils.copyFileContent(srcFile, destFile);
    }

    public static void copyFileContent(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        Utils.copyFileContent(in, out);
    }

    public static void copyFileContent(FileInputStream in, FileOutputStream out) throws IOException {
        try {
            int n;
            while ((n = in.read()) != -1) {
                out.write(n);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void deleteDirectory(String path) throws IOException {
        Utils.deleteDirectory(Paths.get(path, new String[0]));
    }

    public static void deleteDirectory(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void updateSqlnetOraTLS(ProtectedDatabaseMetadata metadata, boolean enableTLS) throws IOException, FileNotFoundException {
        String sqlnetFile = String.join((CharSequence)File.separator, metadata.getNetworkDirectory(), "sqlnet.ora");
        File f = new File(sqlnetFile);
        Sqlnet sqlnet = new Sqlnet();
        if (f.exists()) {
            sqlnet = new Sqlnet(sqlnetFile);
        }
        String AUTH_SERVICES = "SQLNET.AUTHENTICATION_SERVICES";
        Map<String, CallSite> walletParameters = Map.of("SQLNET.WALLET_OVERRIDE", "TRUE", "WALLET_LOCATION", "(SOURCE=(METHOD=FILE)(METHOD_DATA=(DIRECTORY=" + metadata.getWalletLocation() + ")))");
        Map<String, String> tlsParameters = Map.of("SSL_VERSION", "1.2", "SSL_CLIENT_AUTHENTICATION", "FALSE");
        sqlnet.updateParameters(walletParameters);
        if (enableTLS) {
            sqlnet.updateParameters(tlsParameters);
            sqlnet.appendValueToParameter("SQLNET.AUTHENTICATION_SERVICES", "BEQ");
            sqlnet.appendValueToParameter("SQLNET.AUTHENTICATION_SERVICES", "TCPS");
        } else {
            sqlnet.removeParameters(tlsParameters.keySet());
            sqlnet.removeValueFromParameter("SQLNET.AUTHENTICATION_SERVICES", "TCPS");
        }
        sqlnet.writeFile(sqlnetFile);
    }

    public static String getOracleBase() {
        String oracleHome = RCVCommand.getOracleHome();
        if (oracleHome == null) {
            return null;
        }
        SystemCommand command = new SystemCommand();
        ArrayList<CallSite> oraBaseHome = new ArrayList<CallSite>(List.of(oracleHome + File.separator + "bin" + File.separator + "orabase"));
        SystemCommand.ExecutionResult result = command.run(oraBaseHome, false);
        if (result.getReturnCode() == 0) {
            return result.getOutput().replaceAll(System.getProperty("line.separator"), "");
        }
        return null;
    }

    public static String getOracleBaseHome() {
        String oracleHome = RCVCommand.getOracleHome();
        if (oracleHome == null) {
            return null;
        }
        SystemCommand command = new SystemCommand();
        ArrayList<String> oraBaseHome = new ArrayList<String>(Arrays.asList(oracleHome + File.separator + "bin" + File.separator + "orabasehome"));
        SystemCommand.ExecutionResult result = command.run(oraBaseHome, false);
        if (result.getReturnCode() == 0) {
            return result.getOutput().replaceAll(System.getProperty("line.separator"), "");
        }
        return null;
    }

    public static char[] promptAndConfirmPassword(String prompt, String confirm) {
        char[] pwdCharArr;
        Console console = System.console();
        while (true) {
            System.out.println(prompt);
            pwdCharArr = console.readPassword();
            if (pwdCharArr.length == 0) {
                System.out.println("Password cannot be empty!");
                continue;
            }
            System.out.println(confirm);
            char[] pwdCharArr2 = console.readPassword();
            if (Arrays.equals(pwdCharArr, pwdCharArr2)) break;
            System.out.println("Passwords do not match. Please try again.");
        }
        return pwdCharArr;
    }

    public static char[] promptForPassword(String prompt) {
        char[] pwdCharArr;
        Console console = System.console();
        while (true) {
            System.out.println(prompt);
            pwdCharArr = console.readPassword();
            if (pwdCharArr.length != 0) break;
            System.out.println("Password cannot be empty!");
        }
        return pwdCharArr;
    }

    public static boolean confirm(String confirmMessage) {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print(confirmMessage);
            String userInput = scanner.nextLine().trim().toLowerCase();
            if (userInput.equals("yes")) {
                return true;
            }
            if (userInput.equals("no")) {
                return false;
            }
            System.out.println("Invalid input. Please enter 'yes' or 'no'.");
        }
    }

    public static void unzipFile(String archive, String outputDir) {
        File dir = new File(outputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(archive);
            ZipInputStream zis = new ZipInputStream(fis);
            while ((entry = zis.getNextEntry()) != null) {
                int n;
                File file = new File(outputDir + File.separatorChar + entry.getName());
                new File(file.getParent()).mkdirs();
                FileOutputStream out = new FileOutputStream(file);
                while ((n = zis.read()) != -1) {
                    out.write(n);
                }
                out.close();
                zis.closeEntry();
            }
            fis.close();
            zis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generateRandomString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(26);
            char c = (char)(65 + index);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getTimeStamp() {
        Instant now = Instant.now();
        return now.toString();
    }

    public static String getDateAsString() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String timestamp = now.format(formatter);
        return timestamp;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getFirstString(String s) {
        String newline = System.getProperty("line.separator");
        int index = s.contains(newline) ? s.indexOf(newline) : s.length();
        return s.substring(0, index);
    }
}

