/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.extension.rcv.common.Utils;

public class TnsnamesHelper {
    public static Path getTnsnamesFile() {
        String tnsAdmin = System.getenv("TNS_ADMIN");
        if (tnsAdmin != null) {
            return Paths.get(tnsAdmin, "tnsnames.ora");
        }
        return Paths.get(Utils.getOracleBaseHome(), "network", "admin", "tnsnames.ora");
    }

    public static TNSNames getTnsNames(String file) {
        TNSNames tnsNames = null;
        try {
            FileInputStream primaryTnsReader = new FileInputStream(file);
            tnsNames = TNSNames.read((InputStream)primaryTnsReader);
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return tnsNames;
    }

    public static boolean updateIfile(String iFile) throws FileNotFoundException, IOException {
        String tnsPath = TnsnamesHelper.getTnsnamesFile().toString();
        TNSNames primaryTnsNames = TnsnamesHelper.getTnsNames(tnsPath);
        Collection primaryTnsEntries = primaryTnsNames.tnsEntries();
        Set names = primaryTnsNames.nsNames();
        boolean updateTnsNames = false;
        if (!names.contains("IFILE") || !primaryTnsNames.getTNSEntry("IFILE").getConnectionDescriptor().equals(iFile)) {
            updateTnsNames = true;
        }
        if (updateTnsNames) {
            File source = new File(tnsPath);
            File target = new File(tnsPath + ".orig");
            Utils.copyFileContent(source, target);
            FileOutputStream file = new FileOutputStream(tnsPath);
            OutputStreamWriter output = new OutputStreamWriter(file);
            for (String name : names) {
                if (name.equals("IFILE")) {
                    output.write("IFILE = " + iFile + "\n");
                    continue;
                }
                output.write(name + " = " + primaryTnsNames.getTNSEntry(name).getConnectionDescriptor() + "\n");
            }
            if (!names.contains("IFILE")) {
                output.write("IFILE = " + iFile + "\n");
            }
            output.close();
        }
        return updateTnsNames;
    }

    public static boolean removeIfile(String iFile) throws FileNotFoundException, IOException {
        String tnsPath = TnsnamesHelper.getTnsnamesFile().toString();
        TNSNames primaryTnsNames = TnsnamesHelper.getTnsNames(tnsPath);
        Collection primaryTnsEntries = primaryTnsNames.tnsEntries();
        Set names = primaryTnsNames.nsNames();
        boolean updateTnsNames = false;
        if (names.contains("IFILE") && primaryTnsNames.getTNSEntry("IFILE").getConnectionDescriptor().equals(iFile)) {
            updateTnsNames = true;
        }
        if (updateTnsNames) {
            File source = new File(tnsPath);
            File target = new File(tnsPath + ".orig");
            Utils.copyFileContent(source, target);
            FileOutputStream file = new FileOutputStream(tnsPath);
            OutputStreamWriter output = new OutputStreamWriter(file);
            for (String name : names) {
                if (name.equals("IFILE") && primaryTnsNames.getTNSEntry(name).getConnectionDescriptor().equals(iFile)) continue;
                output.write(name + " = " + primaryTnsNames.getTNSEntry(name).getConnectionDescriptor() + "\n");
            }
            output.close();
        }
        return updateTnsNames;
    }
}

