/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public class SshHelper {
    private SshClient client;
    private ClientSession session;
    private String user;
    private String host;
    private String password;
    private String keyFile;
    private int port;
    private SftpFileSystemProvider provider;
    private FileSystem fs;

    public SshHelper(String user, String host, int port, String privateKeyFile) {
        this(user, host, port);
        this.keyFile = privateKeyFile;
    }

    public SshHelper(String user, String host, int port) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.password = "";
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void connect() throws IOException {
        if (this.session == null) {
            this.session = (ClientSession)((ConnectFuture)this.client.connect(this.user, this.host, this.port).verify(30000L)).getSession();
            if (this.keyFile != null && !this.keyFile.isEmpty()) {
                KeyIdentityProvider kip = this.client.getKeyIdentityProvider();
                Path p = Paths.get(new File(this.keyFile).getAbsolutePath(), new String[0]);
                kip = new ClientIdentitiesWatcher(Collections.singletonList(p), () -> ((SshClient)this.client).getClientIdentityLoader(), () -> FilePasswordProvider.of((String)this.password), true);
                this.session.setKeyIdentityProvider(kip);
            } else {
                this.session.addPasswordIdentity(this.password);
                this.session.setKeyIdentityProvider(KeyIdentityProvider.EMPTY_KEYS_PROVIDER);
            }
        }
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.close(false);
            this.session = null;
        }
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fs = null;
        }
    }

    public SftpClient createSftpClient() throws IOException {
        SftpClientFactory factory = SftpClientFactory.instance();
        SftpClient client = factory.createSftpClient(this.session);
        return client.singleSessionInstance();
    }

    private FileSystem getSftpFileSystem() throws IOException {
        if (this.provider == null) {
            this.provider = new SftpFileSystemProvider(this.client);
        }
        if (this.fs == null) {
            URI uri = SftpFileSystemProvider.createFileSystemURI((String)this.host, (int)this.port, (String)this.user, null);
            this.fs = this.provider.newFileSystem(uri, Collections.emptyMap());
        }
        return this.fs;
    }

    public void copy(String src, String target) throws IOException {
        Path srcPath = Paths.get(src, new String[0]);
        FileSystem remoteFileSystem = this.getSftpFileSystem();
        Path targetPath = remoteFileSystem.getPath(target, new String[0]);
        Path parentPath = targetPath.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.copy(srcPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
    }
}

