/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.workflows.AddProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.AddRecoveryServiceSubnetWorkflow;
import oracle.dbtools.extension.rcv.workflows.BackupProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.ChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureAuthenticationWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureBackupWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureLogWorkflow;
import oracle.dbtools.extension.rcv.workflows.DisableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.EnableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.FetchTaskWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowBackupConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowProtectionPolicyWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowRecoveryServiceSubnetWorkflow;
import oracle.dbtools.extension.rcv.workflows.UpdateProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RCVCommandRegistry {
    private static final Map<String, RCVCommandHandler> registry = new HashMap<String, RCVCommandHandler>();
    private static final RCVCommandRegistry instance = new RCVCommandRegistry();

    private RCVCommandRegistry() {
        registry.put(RCVCommand.ADD_PROTECTED_DATABASE, AddProtectedDatabaseWorkflow::new);
        registry.put(RCVCommand.ADD_RECOVERY_SERVICE_SUBNET, AddRecoveryServiceSubnetWorkflow::new);
        registry.put(RCVCommand.BACKUP_PROTECTED_DATABASE, BackupProtectedDatabaseWorkflow::new);
        registry.put(RCVCommand.CONFIGURE_AUTHENTICATION, ConfigureAuthenticationWorkflow::new);
        registry.put(RCVCommand.CONFIGURE_BACKUP, ConfigureBackupWorkflow::new);
        registry.put(RCVCommand.CONFIGURE_LOG, ConfigureLogWorkflow::new);
        registry.put(RCVCommand.DISABLE_REALTIME_REDO, DisableRealtimeRedoWorkflow::new);
        registry.put(RCVCommand.ENABLE_REALTIME_REDO, EnableRealtimeRedoWorkflow::new);
        registry.put(RCVCommand.FETCH_TASK, FetchTaskWorkflow::new);
        registry.put(RCVCommand.REMOVE_PROTECTED_DATABASE, RemoveProtectedDatabaseWorkflow::new);
        registry.put(RCVCommand.RUN_CHECKS, ChecksWorkflow::new);
        registry.put(RCVCommand.SHOW_BACKUP_CONFIG, ShowBackupConfigWorkflow::new);
        registry.put(RCVCommand.SHOW_PROTECTED_DATABASE, ShowProtectedDatabaseWorkflow::new);
        registry.put(RCVCommand.SHOW_PROTECTION_POLICY, ShowProtectionPolicyWorkflow::new);
        registry.put(RCVCommand.SHOW_RECOVERY_SERVICE_SUBNET, ShowRecoveryServiceSubnetWorkflow::new);
        registry.put(RCVCommand.UPDATE_CONFIG, UpdateZRCVConfigurationWorkflow::new);
        registry.put(RCVCommand.UPDATE_PROTECTED_DATABASE, UpdateProtectedDatabaseWorkflow::new);
    }

    public static Workflow getWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        String object;
        String verb;
        String key;
        List tokens = command.getTokens();
        if (tokens.size() >= 3 && registry.containsKey(key = ((verb = String.valueOf(tokens.get(1))) + " " + (object = String.valueOf(tokens.get(2)))).toUpperCase())) {
            RCVCommandHandler handler = registry.get(key);
            return handler.generateWorkflow(command, conn, ctx);
        }
        return null;
    }

    public static interface RCVCommandHandler {
        public Workflow generateWorkflow(ParsedCommand var1, Connection var2, ScriptRunnerContext var3);
    }
}

