/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.rcv.commands.RCVCommandRegistry;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.LogManager;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.TNSHelper;

public class RCVCommand
extends ParsedCommandListener
implements SQLCLService {
    public static final String ADD_PROTECTED_DATABASE = String.valueOf((Object)RCVVerbs.ADD) + " " + String.valueOf((Object)RCVObjects.PROTECTED_DATABASE);
    public static final String ADD_RECOVERY_SERVICE_SUBNET = String.valueOf((Object)RCVVerbs.ADD) + " " + String.valueOf((Object)RCVObjects.RECOVERY_SERVICE_SUBNET);
    public static final String BACKUP_PROTECTED_DATABASE = String.valueOf((Object)RCVVerbs.BACKUP) + " " + String.valueOf((Object)RCVObjects.PROTECTED_DATABASE);
    public static final String CONFIGURE_AUTHENTICATION = String.valueOf((Object)RCVVerbs.CONFIGURE) + " " + String.valueOf((Object)RCVObjects.AUTHENTICATION);
    public static final String CONFIGURE_BACKUP = String.valueOf((Object)RCVVerbs.CONFIGURE) + " " + String.valueOf((Object)RCVObjects.BACKUP);
    public static final String CONFIGURE_LOG = String.valueOf((Object)RCVVerbs.CONFIGURE) + " " + String.valueOf((Object)RCVObjects.LOG);
    public static final String DISABLE_REALTIME_REDO = String.valueOf((Object)RCVVerbs.DISABLE) + " " + String.valueOf((Object)RCVObjects.REALTIME_REDO);
    public static final String ENABLE_REALTIME_REDO = String.valueOf((Object)RCVVerbs.ENABLE) + " " + String.valueOf((Object)RCVObjects.REALTIME_REDO);
    public static final String FETCH_TASK = String.valueOf((Object)RCVVerbs.FETCH) + " " + String.valueOf((Object)RCVObjects.TASK);
    public static final String INIT_CACHE = String.valueOf((Object)RCVVerbs.INIT) + " " + String.valueOf((Object)RCVObjects.CACHE);
    public static final String REMOVE_PROTECTED_DATABASE = String.valueOf((Object)RCVVerbs.REMOVE) + " " + String.valueOf((Object)RCVObjects.PROTECTED_DATABASE);
    public static final String RUN_CHECKS = String.valueOf((Object)RCVVerbs.RUN) + " " + String.valueOf((Object)RCVObjects.CHECKS);
    public static final String SHOW_BACKUP_CONFIG = String.valueOf((Object)RCVVerbs.SHOW) + " " + String.valueOf((Object)RCVObjects.BACKUP_CONFIG);
    public static final String SHOW_PROTECTED_DATABASE = String.valueOf((Object)RCVVerbs.SHOW) + " " + String.valueOf((Object)RCVObjects.PROTECTED_DATABASE);
    public static final String SHOW_PROTECTION_POLICY = String.valueOf((Object)RCVVerbs.SHOW) + " " + String.valueOf((Object)RCVObjects.PROTECTION_POLICY);
    public static final String SHOW_RECOVERY_SERVICE_SUBNET = String.valueOf((Object)RCVVerbs.SHOW) + " " + String.valueOf((Object)RCVObjects.RECOVERY_SERVICE_SUBNET);
    public static final String UPDATE_CONFIG = String.valueOf((Object)RCVVerbs.UPDATE) + " " + String.valueOf((Object)RCVObjects.ZRCV_CONFIG);
    public static final String UPDATE_PROTECTED_DATABASE = String.valueOf((Object)RCVVerbs.UPDATE) + " " + String.valueOf((Object)RCVObjects.PROTECTED_DATABASE);
    private static Logger logger;
    public static int AGENT_VERSION;
    private static Map<String, ProtectedDatabaseMetadata> protectedDatabaseMetadataMap;
    private static ZRCVClientManager zrcvClientManager;
    private static GlobalMetadata globalMetadata;
    private static Map<Connection, String> dbUniqueNameMap;
    private static Map<String, ZRCVClientManager> zrcvClientsMap;
    private static String ORACLE_HOME;
    private static String ORACLE_BASE;
    private static final String LOG_NAME = "rcv.log";

    public static String getOracleHome() {
        if (ORACLE_HOME == null) {
            ORACLE_HOME = TNSHelper.getOracleHome();
        }
        return ORACLE_HOME;
    }

    public static String getOracleBase() {
        if (ORACLE_BASE == null) {
            ORACLE_BASE = Utils.getOracleBase();
        }
        return ORACLE_BASE;
    }

    public static String getDbUniqueName(Connection conn) {
        if (!dbUniqueNameMap.containsKey(conn)) {
            String dbUniqueName = DatabaseUtils.getDbUniqueName(conn);
            dbUniqueNameMap.put(conn, dbUniqueName);
        }
        return dbUniqueNameMap.get(conn);
    }

    public static String getAgentBaseDirectory() {
        if (RCVCommand.getOracleBase() == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, RCVCommand.getOracleBase(), "rcv");
    }

    public static String getGlobalMetadataDirectory() {
        String agentBaseDirectory = RCVCommand.getAgentBaseDirectory();
        if (agentBaseDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, agentBaseDirectory, "metadata");
    }

    public static String getProtectedDatabaseMetadataDirectory(String dbUniqueName) {
        String agentBaseDirectory = RCVCommand.getAgentBaseDirectory();
        if (agentBaseDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, agentBaseDirectory, "dbs", dbUniqueName);
    }

    public static String getNetworkDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "network");
    }

    public static String getWalletDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "wallet");
    }

    public static String getScriptsDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "scripts");
    }

    public static String getLogDirectory(String dbUniqueName) {
        String metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, "log");
    }

    public static String getMetadataPath(String dbUniqueName) {
        String metadataDirectory = RCVCommand.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        if (metadataDirectory == null) {
            return null;
        }
        return String.join((CharSequence)File.separator, metadataDirectory, dbUniqueName + ".json");
    }

    public static void createAgentDirectory(String dbUniqueName) throws IOException {
        ArrayList<String> directories = new ArrayList<String>();
        directories.add(RCVCommand.getAgentBaseDirectory());
        directories.add(RCVCommand.getNetworkDirectory(dbUniqueName));
        directories.add(RCVCommand.getWalletDirectory(dbUniqueName));
        directories.add(RCVCommand.getLogDirectory(dbUniqueName));
        directories.add(RCVCommand.getScriptsDirectory(dbUniqueName));
        for (String directory : directories) {
            if (Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) continue;
            Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        }
    }

    public static boolean isSysBackupConnection(Connection conn, ScriptRunnerContext ctx) {
        String user;
        if (conn == null) {
            return false;
        }
        Properties props = (Properties)ctx.getProperty("cli.conn.props");
        String priv = props.getProperty("internal_logon");
        return !(priv != null ? !"sysbackup".equalsIgnoreCase(priv) && !"sysdba".equalsIgnoreCase(priv) : (user = DatabaseUtils.getUser(conn)) == null || !user.equalsIgnoreCase("sysbackup") && !user.equalsIgnoreCase("sysdba"));
    }

    public static ProtectedDatabaseMetadata getProtectedDatabaseMetadata(String dbUniqueName) {
        if (protectedDatabaseMetadataMap.containsKey(dbUniqueName)) {
            return protectedDatabaseMetadataMap.get(dbUniqueName);
        }
        ProtectedDatabaseMetadata metadata = new ProtectedDatabaseMetadata.Builder(dbUniqueName).build();
        String metadataFile = metadata.getMetadataFile();
        if (metadataFile == null) {
            throw new RuntimeException("Failed to get oracle base.");
        }
        if (Files.exists(Paths.get(metadataFile, new String[0]), new LinkOption[0])) {
            try {
                metadata = ProtectedDatabaseMetadata.load(metadataFile, dbUniqueName);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load protected database metadata from " + metadataFile, e);
            }
        }
        protectedDatabaseMetadataMap.put(dbUniqueName, metadata);
        return metadata;
    }

    public static GlobalMetadata getGlobalMetadata() {
        if (globalMetadata == null) {
            globalMetadata = GlobalMetadata.load();
        }
        return globalMetadata;
    }

    public static ZRCVClientManager createZrcvClientManager() {
        return RCVCommand.createZrcvClientManager(logger);
    }

    public static ZRCVClientManager createZrcvClientManager(Logger logger) {
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        OCIAuthentication authentication = globalMetadata.getAuthentication();
        String endpoint = globalMetadata.getRecoveryServiceEndpoint();
        if (endpoint == null || endpoint.length() == 0) {
            throw Result.metadataStateException("The recovery service endpoint must not be null.");
        }
        return new ZRCVClientManager(authentication, endpoint, logger);
    }

    public static void removeProtectedDatabaseMetadata(String dbUniqueName) {
        if (protectedDatabaseMetadataMap.containsKey(dbUniqueName)) {
            protectedDatabaseMetadataMap.remove(dbUniqueName);
        }
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return RcvMessages.getString("RCV_CMD_DESC");
    }

    public String getExtensionName() {
        return RcvMessages.getString("RCV_CMD_NAME");
    }

    public String getExtensionVersion() {
        return RcvMessages.getString("SQLclVersion.VERSION");
    }

    private void setLogger(Connection conn) {
        logger = LogManager.getLogger("agent", RCVCommand.getDbUniqueName(conn));
    }

    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block17: {
            if (!RCVCommand.isSysBackupConnection(conn, ctx) || DatabaseUtils.isPDB(conn)) {
                ctx.writeln(RcvMessages.format("INVALID_CONNECTION", new Object[]{RCVGrammar.Base.RCV}));
                return true;
            }
            String oracleHome = RCVCommand.getOracleHome();
            if (oracleHome == null || !Files.exists(Paths.get(oracleHome, new String[0]), new LinkOption[0])) {
                ctx.writeln(RcvMessages.format("NO_ORACLE_HOME", new Object[]{RCVGrammar.Base.RCV}));
                return true;
            }
            this.setLogger(conn);
            try {
                Workflow wf = RCVCommandRegistry.getWorkflow(parsedCommand, conn, ctx);
                if (wf != null) {
                    try {
                        if (wf.isApplicable()) {
                            Result result = wf.run();
                            if (result.getStatus().equals((Object)Status.FAILED) || result.getStatus().equals((Object)Status.TIMED_OUT)) {
                                wf.handleFailure();
                                wf.logResult(result);
                            } else if (result.getStatus().equals((Object)Status.SUCCESS)) {
                                if (result.getMessage() != null) {
                                    wf.getLogger().log(Level.INFO, result.getMessage());
                                }
                                wf.getLogger().log(Level.INFO, "rcv " + wf.getName() + " completed successfully");
                            }
                            break block17;
                        }
                        wf.getLogger().log(Level.SEVERE, cmd.getSql().replaceAll("\\r|\\n", "") + " is not applicable.");
                    }
                    catch (Exception e) {
                        wf.logException(e.getCause());
                        logger.log(Level.INFO, Status.FAILED.toString());
                        logger.log(Level.FINE, Utils.getStackTrace(e));
                        String error = e.getMessage();
                        String action = "";
                        if (Result.isHandled(error)) {
                            logger.log(Level.WARNING, Utils.getFirstString(error));
                            action = Result.getAction(error);
                        } else {
                            String msg = Result.getMessage(error, "00015");
                            logger.log(Level.WARNING, msg);
                            action = Result.getAction(msg);
                        }
                        if (!action.isEmpty()) {
                            logger.log(Level.WARNING, action);
                        }
                        wf.handleFailure();
                    }
                    break block17;
                }
                ctx.writeln("Invalid command: " + cmd.getSql());
            }
            catch (Exception e) {
                logger.log(Level.INFO, Status.FAILED.toString());
                logger.log(Level.FINE, Utils.getStackTrace(e));
                String error = e.getMessage();
                String action = "";
                if (Result.isHandled(error)) {
                    logger.log(Level.WARNING, error);
                    action = Result.getAction(error);
                } else {
                    String msg = Result.getMessage(error, "00005");
                    logger.log(Level.WARNING, msg);
                    action = Result.getAction(msg);
                }
                if (action.isEmpty()) break block17;
                logger.log(Level.WARNING, action);
            }
        }
        return true;
    }

    protected Type createType() {
        return RCVGrammar.createType();
    }

    static {
        AGENT_VERSION = 1;
        protectedDatabaseMetadataMap = new HashMap<String, ProtectedDatabaseMetadata>();
        dbUniqueNameMap = new HashMap<Connection, String>();
        zrcvClientsMap = new HashMap<String, ZRCVClientManager>();
    }
}

