/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;

public class TdeEncryptionCheck
extends Check {
    private static final String GET_TABLESPACES = "select tablespace_name, encrypted from dba_tablespaces where contents = 'PERMANENT' order by tablespace_name";
    private Connection conn;

    public TdeEncryptionCheck(Connection conn) {
        super("TDE Encryption Check");
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        ResultSet rs = DBUtil.getInstance((Connection)this.conn).executeOracleQuery(GET_TABLESPACES, null);
        Object message = "";
        CheckResult.Status status = CheckResult.Status.PASS;
        try {
            while (rs.next()) {
                String encrypted = rs.getString("encrypted");
                if (!encrypted.toLowerCase().equals("no")) continue;
                status = CheckResult.Status.FAIL;
                message = (String)message + String.format("Tablespace %s is not encrypted.\n", rs.getString("tablespace_name"));
            }
        }
        catch (SQLException e) {
            status = CheckResult.Status.FAIL;
            message = (String)message + e.getMessage() + "\n";
        }
        return new CheckResult(status, (String)message);
    }
}

