/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;

public class EncryptionKeyCheck
extends Check {
    private static final String GET_ENCRYPTION_KEY = "select count(*) from v$encryption_keys";
    private Connection conn;

    public EncryptionKeyCheck(Connection conn) {
        super("Encryption Key Check");
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        String message = "";
        CheckResult.Status status = CheckResult.Status.PASS;
        String countInString = DatabaseUtils.queryOneRow(this.conn, GET_ENCRYPTION_KEY);
        try {
            int count = Integer.parseInt(countInString);
            if (count == 0) {
                status = CheckResult.Status.FAIL;
                message = "No encryption keys found.";
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to check if encryption keys exist: ", e);
        }
        return new CheckResult(status, message);
    }
}

