/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.check.DatabaseVersionCheck;
import oracle.dbtools.extension.rcv.check.EncryptionKeyCheck;
import oracle.dbtools.extension.rcv.check.Group;

public class Checks {
    private static final String MIN_DB_VERSION = "19.18";

    public static CheckResult runChecks(List<Check> checks, Logger logger) {
        CheckResult.Status allChecksPassed = CheckResult.Status.PASS;
        Object resultMsg = "";
        for (Check check : checks) {
            CheckResult result = check.run();
            CheckResult.Status status = result.getStatus();
            if (logger != null) {
                logger.log(Level.INFO, check.getName() + " - " + String.valueOf((Object)status));
            }
            if (!status.equals((Object)CheckResult.Status.FAIL)) continue;
            allChecksPassed = CheckResult.Status.FAIL;
            if (logger == null) continue;
            logger.log(Level.INFO, "\t" + result.getMessage());
            resultMsg = (String)resultMsg + result.getMessage();
        }
        return new CheckResult(allChecksPassed, (String)resultMsg);
    }

    public static List<Check> getChecks(Group group, Connection conn, boolean isRealtimeRedo) {
        ArrayList<Check> checks = new ArrayList<Check>();
        switch (group) {
            case ALL: {
                checks.add(new DatabaseVersionCheck(conn, MIN_DB_VERSION));
                checks.add(new EncryptionKeyCheck(conn));
                break;
            }
            case ONBOARDING_PRECHECKS: {
                checks.add(new DatabaseVersionCheck(conn, MIN_DB_VERSION));
                checks.add(new EncryptionKeyCheck(conn));
                break;
            }
            default: {
                return checks;
            }
        }
        return checks;
    }
}

