/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportDisplayElement;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;

public final class TextReportLabeledMap
extends TextReportField {
    private final Language lang = Language.getInstance();
    private final String labelText = this.lang.txt(this.getLabelKey());
    private final int labelWidth = this.labelText != null ? this.labelText.length() : 0;
    private final TextValueHint mapHint = this.getValueHint();
    private final Map<?, String> map = (Map)this.value;

    public TextReportLabeledMap(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
    }

    @Override
    public void printText(TextReportSection section) {
        PrintWriter w = this.reportContext.getPrintWriter();
        int labelPadding = section.getWidestLabelWidth() + 1;
        String indent = section.getIndent();
        w.println(section.getIndent() + Utilities.padRight(this.labelText, labelPadding));
        indent = indent + "  ";
        labelPadding -= "  ".length();
        for (Map.Entry<?, String> mapEntry : this.map.entrySet()) {
            String indentedPaddedLabel = indent + Utilities.padRight(mapEntry.getKey().toString() + ":", labelPadding);
            TextReportDisplayElement displayElement = new TextReportDisplayElement(mapEntry.getValue(), this.mapHint);
            int spaceForValue = this.reportContext.getReportWidth() - indentedPaddedLabel.length();
            while (displayElement.hasDataRemaining()) {
                w.println(indentedPaddedLabel + displayElement.getSomeText(spaceForValue));
                indentedPaddedLabel = indent + Utilities.padRight("", labelPadding);
            }
        }
    }

    public Language getLang() {
        return this.lang;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public TextValueHint getMapHint() {
        return this.mapHint;
    }

    public Map<?, String> getMap() {
        return this.map;
    }

    @Override
    public String toString() {
        return "TextReportLabeledMap(lang=" + this.getLang() + ", labelText=" + this.getLabelText() + ", labelWidth=" + this.getLabelWidth() + ", mapHint=" + (Object)((Object)this.getMapHint()) + ", map=" + this.getMap() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportLabeledMap)) {
            return false;
        }
        TextReportLabeledMap other = (TextReportLabeledMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLabelWidth() != other.getLabelWidth()) {
            return false;
        }
        Language this$lang = this.getLang();
        Language other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$labelText = this.getLabelText();
        String other$labelText = other.getLabelText();
        if (this$labelText == null ? other$labelText != null : !this$labelText.equals(other$labelText)) {
            return false;
        }
        TextValueHint this$mapHint = this.getMapHint();
        TextValueHint other$mapHint = other.getMapHint();
        if (this$mapHint == null ? other$mapHint != null : !((Object)((Object)this$mapHint)).equals((Object)other$mapHint)) {
            return false;
        }
        Map<?, String> this$map = this.getMap();
        Map<?, String> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportLabeledMap;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLabelWidth();
        Language $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $labelText = this.getLabelText();
        result = result * 59 + ($labelText == null ? 43 : $labelText.hashCode());
        TextValueHint $mapHint = this.getMapHint();
        result = result * 59 + ($mapHint == null ? 43 : ((Object)((Object)$mapHint)).hashCode());
        Map<?, String> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }
}

