/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import java.util.ArrayList;
import java.util.List;

public final class AnalysisNotes {
    @TextProperty(labelKey="ANALYSIS_NOTES_0_LABEL", section=TextReportSectionName.ANALYSIS_NOTES, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @HtmlProperty(labelKey="ANALYSIS_NOTES_0_LABEL", section=HtmlReportSectionName.ANALYSIS_NOTES, isClassInfo=false)
    private final String numeration;
    @TextProperty(labelKey="ANALYSIS_NOTES_1_DESCRIPTION_LABEL", section=TextReportSectionName.ANALYSIS_NOTES, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @HtmlProperty(labelKey="ANALYSIS_NOTES_1_DESCRIPTION_LABEL", section=HtmlReportSectionName.ANALYSIS_NOTES, isClassInfo=true)
    private final String information;

    public static List<AnalysisNotes> fromStringList(List<String> notes, CheckResult overallResult) {
        ArrayList<AnalysisNotes> notesList = new ArrayList<AnalysisNotes>();
        Language lang = Language.getInstance();
        if (overallResult != CheckResult.FATAL && notes.isEmpty()) {
            notes.add(lang.txt("ANALYSIS_NOTES_COMPLETED_SUCCESSFULLY"));
        }
        if (overallResult == CheckResult.FATAL) {
            notes.add(lang.txt("ANALYSIS_NOTES_COMPLETED_UNSUCCESSFULLY"));
        }
        int numeration = 0;
        for (String note : notes) {
            String numerationStr = "" + ++numeration;
            notesList.add(new AnalysisNotes(numerationStr, note));
        }
        return notesList;
    }

    public AnalysisNotes(String numeration, String information) {
        this.numeration = numeration;
        this.information = information;
    }

    public String getNumeration() {
        return this.numeration;
    }

    public String getInformation() {
        return this.information;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisNotes)) {
            return false;
        }
        AnalysisNotes other = (AnalysisNotes)o;
        String this$numeration = this.getNumeration();
        String other$numeration = other.getNumeration();
        if (this$numeration == null ? other$numeration != null : !this$numeration.equals(other$numeration)) {
            return false;
        }
        String this$information = this.getInformation();
        String other$information = other.getInformation();
        return !(this$information == null ? other$information != null : !this$information.equals(other$information));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $numeration = this.getNumeration();
        result = result * 59 + ($numeration == null ? 43 : $numeration.hashCode());
        String $information = this.getInformation();
        result = result * 59 + ($information == null ? 43 : $information.hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisNotes(numeration=" + this.getNumeration() + ", information=" + this.getInformation() + ")";
    }
}

