/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.logger;

import com.oracle.premigration.cli.CommandInvocationMode;
import com.oracle.premigration.helpers.Utilities;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class PremigrationLogger {
    private static boolean loggerInitialized = false;
    private static FileHandler fileHandler;
    private static Level level;
    private final Logger logger;

    private PremigrationLogger(String name) {
        if (loggerInitialized) {
            this.logger = Logger.getLogger(name);
            this.logger.setUseParentHandlers(false);
            this.logger.addHandler(fileHandler);
            this.logger.setLevel(level);
        } else {
            this.logger = LogManager.getLogManager().getLogger("");
        }
    }

    public static PremigrationLogger getLogger(String name) {
        return new PremigrationLogger(name);
    }

    public static void newConfig(String logFilePath, Level newLevel, CommandInvocationMode commandInvocationMode) throws IOException {
        PremigrationLogger.newConfig(logFilePath, newLevel, commandInvocationMode, false);
    }

    public static void newConfig(String logFilePath, Level newLevel, CommandInvocationMode commandInvocationMode, boolean append) throws IOException {
        level = newLevel;
        int maximumBytes = 0x6400000;
        boolean numberFiles = true;
        fileHandler = new FileHandler(logFilePath, 0x6400000, 1, append);
        fileHandler.setLevel(newLevel);
        SimpleFormatter formatter = new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord logRecord) {
                String format = "[%1$tF %1$tT] [%2$-7s] %3$s %n";
                StringBuilder logMessage = new StringBuilder(String.format("[%1$tF %1$tT] [%2$-7s] %3$s %n", new Date(logRecord.getMillis()), logRecord.getLevel().getLocalizedName(), logRecord.getMessage()));
                Throwable throwable = logRecord.getThrown();
                if (throwable != null) {
                    logMessage.append(Utilities.exceptionStackTraceToString(throwable));
                }
                return logMessage.toString();
            }
        };
        fileHandler.setFormatter(formatter);
        if (commandInvocationMode == CommandInvocationMode.RUN_FROM_CLI) {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            LogManager.getLogManager().reset();
            rootLogger.setLevel(newLevel);
            rootLogger.addHandler(fileHandler);
        }
        loggerInitialized = true;
    }

    public void shutdown() {
        fileHandler.close();
        this.logger.removeHandler(fileHandler);
    }

    public void logRecord(Level level, String message) {
        this.logger.log(level, message);
    }

    public void logRecord(Level level, String message, Throwable throwable) {
        this.logger.log(level, message, throwable);
    }

    public void trace(String message) {
        this.logRecord(Level.FINEST, message);
    }

    public void fine(String message) {
        this.logRecord(Level.FINE, message);
    }

    public void info(String message) {
        this.logRecord(Level.INFO, message);
    }

    public void warning(String message) {
        this.logRecord(Level.WARNING, message);
    }

    public void severe(String message) {
        this.logRecord(Level.SEVERE, message);
    }

    public void trace(String message, Throwable x) {
        this.logRecord(Level.FINEST, message, x);
    }

    public void fine(String message, Throwable x) {
        this.logRecord(Level.FINE, message, x);
    }

    public void info(String message, Throwable x) {
        this.logRecord(Level.INFO, message, x);
    }

    public void warning(String message, Throwable x) {
        this.logRecord(Level.WARNING, message, x);
    }

    public void severe(String message, Throwable x) {
        this.logRecord(Level.SEVERE, message, x);
    }

    public static boolean isLoggerInitialized() {
        return loggerInitialized;
    }
}

