/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;

public class AnalysisPropHelper {
    private final String migrationTablespaceMapping;
    private final List<String> defaultList;
    private final List<String> columnNames;
    private final List<String> targetPropTablespacesList = new ArrayList<String>();
    private final List<String> migrationMethodPropTablespacesNotMappedList = new ArrayList<String>();

    public AnalysisPropHelper(ExecutionContext exeCtx, List<String> defaultList, List<String> columnNames) {
        String migrationMethodPropTablespacesNotMapped;
        this.defaultList = defaultList;
        this.columnNames = columnNames;
        this.migrationTablespaceMapping = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACE_MAPPING.getKey());
        String targetPropTablespaces = exeCtx.getAnalysisProperty(TargetInstanceProp.TABLESPACES.getKey());
        if (targetPropTablespaces != null && !targetPropTablespaces.trim().isEmpty()) {
            this.targetPropTablespacesList.addAll(Arrays.asList(targetPropTablespaces.trim().split(",")));
        }
        if ((migrationMethodPropTablespacesNotMapped = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey())) != null && !migrationMethodPropTablespacesNotMapped.trim().isEmpty()) {
            this.migrationMethodPropTablespacesNotMappedList.addAll(Arrays.asList(migrationMethodPropTablespacesNotMapped.trim().split(",")));
        }
    }

    public String getTablespaceAndClause() {
        boolean hasListOfTargetTablespaces = true;
        boolean hasListOfUnmappedTablespaces = true;
        if (this.targetPropTablespacesList.isEmpty()) {
            hasListOfTargetTablespaces = false;
        }
        if (this.migrationMethodPropTablespacesNotMappedList.isEmpty()) {
            hasListOfUnmappedTablespaces = false;
        }
        String andClause = hasListOfUnmappedTablespaces ? SqlUtils.createAndOfOrClauses(this.columnNames, true, this.migrationMethodPropTablespacesNotMappedList) : (hasListOfTargetTablespaces ? SqlUtils.createAndOfOrClauses(this.columnNames, false, this.targetPropTablespacesList) : SqlUtils.createAndOfOrClauses(this.columnNames, false, this.defaultList));
        return " " + andClause;
    }

    public boolean isMigrationMethodMappingAll() {
        return this.migrationTablespaceMapping != null && "ALL".equals(this.migrationTablespaceMapping.trim());
    }

    public static void processAnalysisProperties(Properties analysisProps, String appVersion, List<String> notes, ExecutionContext exeCtx) throws SQLException {
        String propsAppVersion = analysisProps.getProperty(TargetInstanceProp.CPAT_VERSION.getKey());
        if (propsAppVersion != null && !Objects.equals(appVersion, propsAppVersion)) {
            String warningText = Utilities.getErrorText("ERROR2004", new String[0]);
            Utilities.printAndLogErrorMessage(warningText, exeCtx.getEnvCtx(), Level.WARNING);
        }
        AnalysisPropHelper.processAdditionalExcludesProp(analysisProps, exeCtx);
        AnalysisPropHelper.processSkipChecks(analysisProps, exeCtx);
        AnalysisPropHelper.processDirectoryProps(analysisProps);
        AnalysisPropHelper.processTablespaceProps(analysisProps, exeCtx);
        AnalysisPropHelper.processTargetDBVersion(analysisProps, exeCtx);
        AnalysisPropHelper.processLockdownCloudService(analysisProps, notes, exeCtx);
    }

    private static void processAdditionalExcludesProp(Properties analysisProps, ExecutionContext exeCtx) throws SQLException {
        String additionalExcludesProp = analysisProps.getProperty(SourceAnalysisProp.ADDITIONAL_EXCLUDED_SCHEMAS.getKey());
        if (exeCtx.getParsedArgs().getSchemas().isEmpty() && additionalExcludesProp != null && !additionalExcludesProp.trim().isEmpty()) {
            ArrayList<String> additionalExcludes = new ArrayList<String>(Arrays.asList(additionalExcludesProp.trim().split(",")));
            List<String> invalidNames = SqlUtils.getInvalidSchemaNames(additionalExcludes, exeCtx);
            additionalExcludes.removeAll(invalidNames);
            List<String> excludeSchemas = exeCtx.getExcludeSchemas();
            for (String additionalExcludeName : additionalExcludes) {
                String trimmedAdditionalExcludeName = additionalExcludeName.trim();
                if (excludeSchemas.contains(trimmedAdditionalExcludeName)) continue;
                excludeSchemas.add(trimmedAdditionalExcludeName);
            }
        }
    }

    private static void processSkipChecks(Properties analysisProps, ExecutionContext exeCtx) {
        String skipChecksProp = analysisProps.getProperty(SourceAnalysisProp.SKIP_CHECKS.getKey());
        if (skipChecksProp != null && !skipChecksProp.isEmpty()) {
            String[] checkNames;
            for (String checkName : checkNames = skipChecksProp.split(",")) {
                String trimmedCheckName = checkName.trim();
                if (trimmedCheckName.isEmpty()) continue;
                exeCtx.getSkipChecks().add(trimmedCheckName);
            }
        }
    }

    private static void processDirectoryProps(Properties analysisProps) {
        String targetDirsProp = analysisProps.getProperty(TargetInstanceProp.DIRECTORIES.getKey());
        String migrationDirsProp = analysisProps.getProperty(MigrationMethodProp.DIRECTORY_MAPPING.getKey());
        if (targetDirsProp != null || migrationDirsProp != null) {
            LinkedHashSet<String> directorySet = new LinkedHashSet<String>();
            if (targetDirsProp != null) {
                directorySet.addAll(Arrays.asList(targetDirsProp.trim().split(",")));
            }
            if (migrationDirsProp != null) {
                directorySet.addAll(Arrays.asList(migrationDirsProp.trim().split(",")));
            }
            String directories = Utilities.join(",", directorySet);
            analysisProps.setProperty(SourceAnalysisProp.DIRECTORIES.getKey(), directories);
        }
    }

    private static void processTablespaceProps(Properties analysisProps, ExecutionContext exeCtx) {
        String migrationMethodTablespacesNotMappedProp;
        String targetTablespacesProp = analysisProps.getProperty(TargetInstanceProp.TABLESPACES.getKey());
        if (targetTablespacesProp != null) {
            ArrayList<String> targetTablespacesList = new ArrayList<String>(Arrays.asList(targetTablespacesProp.trim().split(",")));
            String tablespaceNames = Utilities.join(",", SqlUtils.cleanAndValidateTablespaceNamesValue(targetTablespacesList, exeCtx, "TargetInstanceProp.TABLESPACES"));
            analysisProps.setProperty(TargetInstanceProp.TABLESPACES.getKey(), tablespaceNames);
        }
        if ((migrationMethodTablespacesNotMappedProp = analysisProps.getProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey())) != null) {
            ArrayList<String> migrationMethodTablespacesNotMappedList = new ArrayList<String>(Arrays.asList(migrationMethodTablespacesNotMappedProp.trim().split(",")));
            String tablespaceNames = Utilities.join(",", SqlUtils.cleanAndValidateTablespaceNamesValue(migrationMethodTablespacesNotMappedList, exeCtx, "MigrationMethodProp.TABLESPACES_NOT_MAPPED"));
            analysisProps.setProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey(), tablespaceNames);
        }
    }

    private static void processTargetDBVersion(Properties analysisProps, ExecutionContext exeCtx) {
        String targetDatabaseVersionValue = analysisProps.getProperty(TargetInstanceProp.DB_VERSION.getKey());
        if (targetDatabaseVersionValue != null) {
            try {
                Version.toList(targetDatabaseVersionValue);
            }
            catch (Exception e) {
                String warningText = Utilities.getErrorText("ERROR4004", new String[0]);
                Utilities.printAndLogErrorMessage(warningText, exeCtx.getEnvCtx(), Level.WARNING, e);
                analysisProps.setProperty(TargetInstanceProp.DB_VERSION.getKey(), "");
            }
        }
    }

    private static void processLockdownCloudService(Properties analysisProps, List<String> notes, ExecutionContext exeCtx) {
        String targetPDBLockdownProfile = analysisProps.getProperty(TargetInstanceProp.PDB_LOCKDOWN.getKey());
        String targetCloudService = analysisProps.getProperty(TargetInstanceProp.CLOUD_SERVICE.getKey());
        if (targetCloudService != null && targetPDBLockdownProfile != null) {
            LockdownProfile targetCloudLockdownProfile;
            LockdownProfile targetLockdownProfile = LockdownProfile.fromLockdownProfileAndCloudService(targetPDBLockdownProfile, targetCloudService);
            if (exeCtx.getParsedArgs().getTargetCloud() == null) {
                TargetCloud targetCloud = targetLockdownProfile.toTargetCloud();
                if (targetCloud == null) {
                    return;
                }
                exeCtx.getParsedArgs().setTargetCloud(targetCloud);
            }
            if (targetLockdownProfile != (targetCloudLockdownProfile = LockdownProfile.fromTargetCloud(exeCtx.getParsedArgs().getTargetCloud()))) {
                notes.add(Utilities.getAnalysisNoteText("ERROR2007", new Object[0]));
                String warningText = Utilities.getErrorText("ERROR2007", new String[0]);
                Utilities.printAndLogErrorMessage(warningText, exeCtx.getEnvCtx(), Level.WARNING);
            }
        }
    }
}

