/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class unified_or_standard_audit_base
extends Check {
    protected String unifiedAuditing = null;
    protected String auditTrail = null;
    protected String auditSysOperations = null;
    protected CheckResult multiPurposeResult = null;

    protected unified_or_standard_audit_base() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setGrouping(Check.Group.OTHER);
    }

    protected void fetchAuditValues(ExecutionContext exeCtx) throws SQLException {
        if (this.unifiedAuditing == null) {
            this.unifiedAuditing = SqlUtils.getSingleString("SELECT VALUE FROM V$OPTION WHERE PARAMETER = 'Unified Auditing'", "FALSE", exeCtx).toUpperCase();
        }
        if (this.auditTrail == null) {
            this.auditTrail = SqlUtils.getSingleString("SELECT VALUE FROM V$PARAMETER WHERE NAME = 'audit_trail'", "NONE", exeCtx).toUpperCase();
        }
        if (this.auditSysOperations == null) {
            this.auditSysOperations = SqlUtils.getSingleString("SELECT VALUE FROM V$PARAMETER WHERE NAME = 'audit_sys_operations'", "NONE", exeCtx).toUpperCase();
        }
    }

    protected void setAuditQuery(ExecutionContext exeCtx) {
        if ("NONE".equals(this.auditTrail)) {
            String sqlQuery = "SELECT NULL AS USER_OR_OWNER, NULL AS OBJECT_NAME, NULL AS CLASS FROM DUAL WHERE 1=0";
            this.setSqlQuery(sqlQuery);
        } else {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USER_OR_OWNER");
            String sqlQuery = "SELECT USER_OR_OWNER, OBJECT_NAME, CLASS FROM  ((SELECT AUDIT_OPTION AS OBJECT_NAME, USER_NAME AS USER_OR_OWNER, 'STATEMENT' AS CLASS FROM  SYS.DBA_STMT_AUDIT_OPTS) UNION  (SELECT PRIVILEGE AS OBJECT_NAME, USER_NAME AS USER_OR_OWNER, 'PRIVILEGE' AS CLASS FROM SYS.DBA_PRIV_AUDIT_OPTS) UNION  (SELECT OBJECT_NAME, OWNER AS USER_OR_OWNER, 'OBJECT' AS CLASS FROM SYS.DBA_OBJ_AUDIT_OPTS ))" + whereClause + " OR USER_OR_OWNER IS NULL ORDER BY 1,3,2";
            this.setSqlQuery(sqlQuery);
        }
    }

    @Override
    public CheckResult determineResult() {
        if ("TRUE".equals(this.auditSysOperations)) {
            String audSysOpsAction = this.lang.txt("CHECK.UNIFIED_OR_STANDARD_TRADITIONAL_AUDIT.AUDIT_SYS_OPS_BAD", this.auditSysOperations);
            this.setAction(this.getAction() + "\n" + audSysOpsAction);
            return this.multiPurposeResult;
        }
        if (this.getRelevantObjectsData() != null && !this.getRelevantObjectsData().isEmpty()) {
            return this.multiPurposeResult;
        }
        return CheckResult.PASS;
    }
}

