/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public class has_users_with_10g_password_version
extends Check {
    public has_users_with_10g_password_version() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWS, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String sqlQuery = "SELECT USERNAME, PASSWORD_VERSIONS FROM SYS.DBA_USERS " + whereClause + " AND ( RTRIM(PASSWORD_VERSIONS) = '10G'        OR RTRIM(PASSWORD_VERSIONS) = '10G HTTP')  AND USERNAME <> 'ANONYMOUS'  ORDER BY 1";
        this.setSqlQuery(sqlQuery);
    }
}

