/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_tables_with_xmltype_column
extends FilterableCheck {
    public has_tables_with_xmltype_column() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasXmlTabCols = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_XML_TAB_COLS").build());
        if (!hasXmlTabCols) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_COMPONENT_NOT_INSTALLED", this.getName(), "XDB"), CheckResult.PASS);
            return;
        }
        String targetDatabaseVersion = exeCtx.getAnalysisProperty(TargetInstanceProp.DB_VERSION.getKey());
        if (targetDatabaseVersion != null && !targetDatabaseVersion.trim().isEmpty() && Version.V19_18_0_0.compare(targetDatabaseVersion) <= 0) {
            String transformMessage = this.lang.txt("CHECK_WITH_XMLTYPE_CLOB_ACTION_TRANSFORM");
            this.setAction(this.getAction() + transformMessage);
        }
        String xmlTransformEnabled = exeCtx.getAnalysisProperty(MigrationMethodProp.XML_STORAGE_TRANSFORM.getKey(), "false");
        String orStorageIsBinaryClause = "";
        if (!"true".equalsIgnoreCase(xmlTransformEnabled)) {
            orStorageIsBinaryClause = " OR XTC.STORAGE_TYPE != 'BINARY'";
        }
        boolean hasUserGenerated = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_TAB_COLS").column("USER_GENERATED").build());
        String excludeUnusedColumns = "";
        String fromDbaTabColsTC = "";
        if (hasUserGenerated) {
            fromDbaTabColsTC = " ,SYS.DBA_TAB_COLS TC ";
            excludeUnusedColumns = " AND TC.OWNER = XTC.OWNER AND TC.TABLE_NAME = XTC.TABLE_NAME AND TC.COLUMN_NAME = XTC.COLUMN_NAME AND NOT (TC.HIDDEN_COLUMN='YES' AND TC.USER_GENERATED='NO')";
        }
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "XTC.OWNER");
        String xmlTypeColumnsSql = "SELECT XTC.OWNER, XTC.TABLE_NAME, XTC.COLUMN_NAME, XTC.STORAGE_TYPE, XTC.XMLSCHEMA, XTC.SCHEMA_OWNER  FROM SYS.DBA_XML_TAB_COLS XTC " + fromDbaTabColsTC + whereClause + " AND (XTC.XMLSCHEMA IS NOT NULL" + orStorageIsBinaryClause + ")" + excludeUnusedColumns + " ORDER BY 1,2,3";
        this.setSqlQuery(xmlTypeColumnsSql);
    }
}

