/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_tables_that_fail_with_dblink
extends FilterableCheck {
    public has_tables_that_fail_with_dblink() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().add(MigrationMethod.DATAPUMP_DBLINK);
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.MIGRATION_METHOD);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (Version.V12_2_0_1.compare(exeCtx.getDatabaseVersion()) > 0) {
            String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
            String longRawColumnSQL = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE, 'IMPORT, EXPORT' AS FAILS_WITH  FROM SYS.DBA_TAB_COLS " + whereClause + " AND DATA_TYPE IN ('LONG','LONG RAW') ORDER BY 1,2,3";
            this.setSqlQuery(longRawColumnSQL);
        } else {
            boolean canSelectSysCol$ = exeCtx.canSelectDatabaseObject(DatabaseObject.builder().schema("SYS").table("COL$").build());
            String secondColumnPredicate = canSelectSysCol$ ? "    AND (TC2.DATA_TYPE = 'BFILE'         OR          EXISTS (SELECT NULL FROM SYS.DBA_OBJECTS O,                                 SYS.COL$ C                             WHERE TC2.OWNER = O.OWNER                               AND TC2.TABLE_NAME = O.OBJECT_NAME                               AND O.OBJECT_ID = C.OBJ#                               AND C.INTCOL# = TC2.COLUMN_ID                               AND C.TYPE# = 58 ))" : " AND TC2.DATA_TYPE IN ('BFILE','ANYDATA','ANYDATASET','ANYTYPE','XMLTYPE') ";
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "TC1.OWNER");
            String longComboSQL = "WITH EXPORT_FAILS AS  ( SELECT   TC1.OWNER AS OWNER   ,TC1.TABLE_NAME AS TABLE_NAME   ,TC1.COLUMN_NAME LONG_COLUMN   ,TC1.DATA_TYPE   LONG_TYPE   FROM SYS.DBA_TAB_COLUMNS TC1 " + whereClause + "  AND TC1.DATA_TYPE IN('LONG','LONG RAW') ),  IMPORT_EXPORT_FAILS AS ( SELECT   TC1.OWNER   ,TC1.TABLE_NAME   ,TC2.COLUMN_NAME   ,TC2.DATA_TYPE FROM   SYS.DBA_TAB_COLUMNS TC1,   SYS.DBA_TAB_COLUMNS TC2 " + whereClause + "  AND TC1.OWNER = TC2.OWNER   AND TC1.TABLE_NAME = TC2.TABLE_NAME   AND TC1.DATA_TYPE IN('LONG','LONG RAW') " + secondColumnPredicate + ") SELECT OWNER, TABLE_NAME, LONG_COLUMN, LONG_TYPE, COLUMN_NAME, DATA_TYPE,    (CASE WHEN COLUMN_NAME IS NULL THEN 'EXPORT' ELSE 'IMPORT, EXPORT' END) AS FAILS_WITH FROM EXPORT_FAILS EF LEFT JOIN IMPORT_EXPORT_FAILS IEF USING (OWNER, TABLE_NAME) ORDER BY 1, 2, 3";
            this.setSqlQuery(longComboSQL);
        }
    }
}

