/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_logging_off;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;

public class has_logging_off_for_tables
extends has_logging_off {
    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        super.prepare(exeCtx);
        if (!this.isSkipExecution()) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "T.OWNER");
            String sqlQuery = "SELECT   T.OWNER,   T.TABLE_NAME,   T.TABLESPACE_NAME  FROM   SYS.DBA_TABLES T, SYS.DBA_TABLESPACES S " + whereClause + "  AND NVL(T.LOGGING,       (CASE S.LOGGING         WHEN 'LOGGING' THEN 'YES'         WHEN 'NOLOGGING' THEN 'NO'         ELSE NULL        END)     ) = 'NO'   AND NVL(T.TEMPORARY,'N')!= 'Y'   AND T.TABLE_NAME NOT LIKE 'AQ$%'   AND T.TABLE_NAME NOT LIKE 'DR$%'   AND T.TABLE_NAME NOT LIKE 'RUPD$%'   AND T.TABLESPACE_NAME = S.TABLESPACE_NAME   AND NOT NVL(S.FORCE_LOGGING, 'NO') = 'YES'  ORDER BY 1, 2";
            this.setSqlQuery(sqlQuery);
        }
    }
}

