/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;
import java.util.List;

public abstract class gg_tables_not_supported
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(gg_tables_not_supported.class.getName());
    protected List<String> unsupportedModes;

    protected gg_tables_not_supported() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.MIGRATION_METHOD);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean isVersion12;
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GGSM.OWNER");
        String supportModeClause = SqlUtils.createAndClause("SUPPORT_MODE", true, this.unsupportedModes);
        String sqlQuery = "SELECT OWNER, OBJECT_NAME, SUPPORT_MODE  FROM SYS.DBA_GOLDENGATE_SUPPORT_MODE GGSM " + whereClause + supportModeClause;
        try {
            isVersion12 = Version.betweenInclusive(exeCtx.getDatabaseVersion(), Version.V12_1_0_1, Version.V12_2_0_2);
        }
        catch (Exception e) {
            log.severe("Exception calling Version.betweenInclusive with '" + exeCtx.getDatabaseVersion() + "'", e);
            isVersion12 = false;
        }
        if (isVersion12) {
            whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "DTC.OWNER");
            sqlQuery = sqlQuery + " UNION  SELECT DTC.OWNER, DTC.TABLE_NAME AS OBJECT_NAME, 'NONE' AS SUPPORT_MODE   FROM SYS.DBA_TAB_COLUMNS DTC " + whereClause + "   AND DTC.IDENTITY_COLUMN='YES'";
        }
        this.setSqlQuery(sqlQuery);
    }
}

