/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import java.io.IOException;
import java.util.Arrays;

public class gg_force_logging
extends Check
implements Fixable {
    public gg_force_logging() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT force_logging FROM v$database WHERE force_logging = 'NO'");
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "gg_enable_force_logging";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("gg_enable_force_logging", locus, parentFolderPath).runAtCDBLevel(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

