/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.cli.CommandInvocationMode;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.commons.io.OutputFilenamesContainer;
import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.filters.FilterCriteria;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import oracle.security.pki.OraclePKIProvider;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class ExecutionContext {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ExecutionContext.class.getName());
    private PoolDataSource pds;
    private final EnvironmentContext envCtx;
    private final CommandLineArgs parsedArgs;
    private List<String> invalidSchemaNames;
    private List<String> defaultExcludeSchemas = Collections.emptyList();
    private List<String> validTablespaceNames;
    private final Map<DatabaseObject, Boolean> hasDatabaseObjectCache = new HashMap<DatabaseObject, Boolean>();
    private final Map<DatabaseObject, Boolean> canSelectDatabaseObjectCache = new HashMap<DatabaseObject, Boolean>();
    private OutputFilenamesContainer outputFilenamesContainer;
    private String databaseVersion;
    private String databasePlatformHW;
    private String databasePlatformOS;
    private long databasePlatformID;
    private boolean databaseIsCDB;
    private LockdownProfile lockdownProfile;
    private FilterCriteria filterCriteria;
    private final Set<String> skipChecks = new HashSet<String>();
    final Set<ZipContributor> zipContents = new HashSet<ZipContributor>();
    private final Properties analysisProperties = new Properties(){

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    };
    private final Properties defaultAnalysisProperties = new Properties();
    private final boolean hasOracleMaintained;
    private final boolean hasDbmsCloudPkg;
    private final AnalysisMode analysisMode;
    private String containerName;
    private boolean cdbRootConnection;

    public ExecutionContext(CommandLineArgs commandLineArgs, OutputFilenamesContainer outputFilenamesContainer, EnvironmentContext envCtx) throws SQLException {
        boolean hasDbmsCloudPkg;
        this.parsedArgs = commandLineArgs;
        this.envCtx = envCtx;
        this.outputFilenamesContainer = outputFilenamesContainer;
        Security.insertProviderAt((Provider)new OraclePKIProvider(), 3);
        if (envCtx.getCommandInvocationMode() == CommandInvocationMode.RUN_FROM_CLI) {
            this.pds = PoolDataSourceFactory.getPoolDataSource();
            log.info("Disabling FCF");
            this.pds.setFastConnectionFailoverEnabled(false);
            this.pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            this.pds.setURL(commandLineArgs.getConnectString());
            if (commandLineArgs.getUsername() != null) {
                this.pds.setUser(commandLineArgs.getUsername());
            }
            if (commandLineArgs.getPassword() != null) {
                this.pds.setPassword(new String(commandLineArgs.getPassword()));
            }
            if (commandLineArgs.isSysdba()) {
                Properties props = new Properties();
                props.put("internal_logon", "sysdba");
                this.pds.setConnectionProperties(props);
            }
            if (commandLineArgs.getPdbNames() != null && commandLineArgs.getPdbNames().size() == 1) {
                this.alterSessionSetContainer(commandLineArgs.getPdbName());
            }
        }
        this.analysisMode = this.parsedArgs.isForceFull() || this.parsedArgs.getSchemas().isEmpty() ? AnalysisMode.FULL : AnalysisMode.SCHEMA;
        String dbaObjectsQuery = "SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='DBA_OBJECTS' AND COLUMN_NAME='ORACLE_MAINTAINED' AND OWNER='SYS'";
        this.hasOracleMaintained = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='DBA_OBJECTS' AND COLUMN_NAME='ORACLE_MAINTAINED' AND OWNER='SYS'", this) > 0L;
        String dbaDbmsCloudPkgQuery = "SELECT COUNT(OBJECT_NAME) FROM DBA_OBJECTS WHERE OBJECT_NAME = 'DBMS_CLOUD' AND OBJECT_TYPE='PACKAGE BODY'";
        try {
            hasDbmsCloudPkg = SqlUtils.getSingleLong("SELECT COUNT(OBJECT_NAME) FROM DBA_OBJECTS WHERE OBJECT_NAME = 'DBMS_CLOUD' AND OBJECT_TYPE='PACKAGE BODY'", this) > 0L;
        }
        catch (SQLException e) {
            log.warning("Unexpected exception fetching DBMS_CLOUD package;", e);
            hasDbmsCloudPkg = false;
        }
        this.hasDbmsCloudPkg = hasDbmsCloudPkg;
        this.initLockdownProfile();
        this.checkForInvalidSchemaNames();
        this.initDefaultExcludedSchemaNames();
        this.initDatabaseVersion();
        this.initDatabasePlatform();
        this.initCDBProperties();
        this.initTablespaceNames();
        if (!this.isAnalysisOfMultiplePdbs()) {
            commandLineArgs.nullifyPassword();
        }
    }

    public void closeIfNotNull(ResultSet rs, PreparedStatement stmt, Connection conn) throws SQLException {
        HashMap<String, SQLException> deferredExceptions = new HashMap<String, SQLException>();
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            deferredExceptions.put("ResultSet", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            deferredExceptions.put("PreparedStatement", e);
        }
        try {
            if (conn != null && this.envCtx.getCommandInvocationMode() == CommandInvocationMode.RUN_FROM_CLI) {
                conn.close();
            }
        }
        catch (SQLException e) {
            deferredExceptions.put("Connection", e);
        }
        if (!deferredExceptions.isEmpty()) {
            SQLException sqlException = new SQLException();
            for (Map.Entry entry : deferredExceptions.entrySet()) {
                String key = (String)entry.getKey();
                sqlException = (SQLException)deferredExceptions.get(key);
                log.severe(Utilities.getErrorText("ERROR2002", sqlException, key));
            }
            throw sqlException;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.envCtx.getCommandInvocationMode() == CommandInvocationMode.RUN_FROM_CLI) {
            return this.pds.getConnection();
        }
        return this.envCtx.getConnection();
    }

    public List<String> getSourceSchemas() {
        return this.parsedArgs.getSchemas();
    }

    public boolean isUsingOGG() {
        return this.getParsedArgs().getMigrationMethods().contains(MigrationMethod.GOLDENGATE) || this.getParsedArgs().getMigrationMethods().contains(MigrationMethod.ALL);
    }

    public boolean isAnalysisOfMultiplePdbs() {
        if (this.getParsedArgs().isFetchTargetProps() || !this.isCdbRootConnection()) {
            return false;
        }
        List<String> pdbNames = this.getParsedArgs().getPdbNames();
        return pdbNames != null && pdbNames.size() != 1;
    }

    public List<String> getExcludeSchemas() {
        if (!this.defaultExcludeSchemas.isEmpty()) {
            return this.defaultExcludeSchemas;
        }
        return this.parsedArgs.getExcludeSchemas();
    }

    public String getAnalysisProperty(String propertyName) {
        return this.analysisProperties.getProperty(propertyName);
    }

    public String getAnalysisProperty(String propertyName, String defaultValue) {
        return this.analysisProperties.getProperty(propertyName, defaultValue);
    }

    public List<String> getTablespacesNames() {
        return this.validTablespaceNames;
    }

    private void checkForInvalidSchemaNames() throws SQLException {
        List<String> targetSchemas = this.getParsedArgs().getSchemas();
        List<String> excludeSchemas = this.getParsedArgs().getExcludeSchemas();
        List<String> namesToCheck = targetSchemas != null && !targetSchemas.isEmpty() ? targetSchemas : excludeSchemas;
        this.invalidSchemaNames = SqlUtils.getInvalidSchemaNames(namesToCheck, this);
        if (!this.invalidSchemaNames.isEmpty()) {
            this.getParsedArgs().nullifyAllSchemaNames();
        }
    }

    private void initDefaultExcludedSchemaNames() throws SQLException {
        List<String> targetSchemas = this.getParsedArgs().getSchemas();
        List<String> excludeSchemas = this.getParsedArgs().getExcludeSchemas();
        if (targetSchemas != null && targetSchemas.isEmpty() && excludeSchemas != null && excludeSchemas.isEmpty()) {
            this.defaultExcludeSchemas = SqlUtils.getExcludedSchemaDefaults(this);
        }
    }

    private void initDatabaseVersion() throws SQLException {
        try {
            this.databaseVersion = SqlUtils.getSingleString("SELECT VERSION_FULL FROM V$INSTANCE", this);
        }
        catch (SQLException e) {
            this.databaseVersion = SqlUtils.getSingleString("SELECT VERSION FROM V$INSTANCE", this);
        }
    }

    private void initCDBProperties() throws SQLException {
        this.containerName = "";
        try {
            this.containerName = SqlUtils.getSingleString("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') CON_NAME FROM DUAL", this);
        }
        catch (SQLException e) {
            log.trace("Exception attempting to determine the source database container name. ", e);
        }
        this.cdbRootConnection = "CDB$ROOT".equals(this.containerName);
        if (Version.V11_2_0_4.compare(this.databaseVersion) >= 0) {
            this.databaseIsCDB = false;
        } else {
            String cdb = SqlUtils.getSingleString("SELECT CDB FROM V$DATABASE", this);
            this.databaseIsCDB = "YES".equals(cdb);
        }
    }

    private void initDatabasePlatform() throws SQLException {
        String databasePlatform = SqlUtils.getSingleString("SELECT DBMS_UTILITY.PORT_STRING FROM DUAL", this);
        log.info("Source Database DBMS_UTILITY.PORT_STRING: " + databasePlatform);
        String[] platformComps = databasePlatform.split("/");
        this.databasePlatformHW = platformComps[0];
        if (platformComps.length > 1) {
            this.databasePlatformOS = platformComps[1];
        } else {
            this.databasePlatformOS = SqlUtils.getSingleString("SELECT PLATFORM_NAME FROM V$DATABASE", this);
            log.info("Source Database PLATFORM_NAME: " + databasePlatform);
        }
        this.databasePlatformID = SqlUtils.getSingleLong("SELECT TRUNC (PLATFORM_ID) INT_ID FROM V$DATABASE", this);
        log.info("Source Database PLATFORM_ID: " + this.databasePlatformID);
    }

    private void initTablespaceNames() throws SQLException {
        this.validTablespaceNames = SqlUtils.getStringList("SELECT TABLESPACE_NAME FROM SYS.DBA_TABLESPACES", this);
    }

    private void initLockdownProfile() {
        try {
            String lockdownProfileEnv = System.getProperty("cpat.lockdownProfile", null);
            if (lockdownProfileEnv != null) {
                this.lockdownProfile = LockdownProfile.valueOf(lockdownProfileEnv);
                return;
            }
        }
        catch (Exception e) {
            this.lockdownProfile = LockdownProfile.NONE;
            return;
        }
        try {
            String pdbLockdownProfile = SqlUtils.getSingleString("SELECT UPPER(VALUE) AS PDB_LOCKDOWN FROM V$PARAMETER WHERE UPPER(NAME) = 'PDB_LOCKDOWN'", this);
            log.fine("pdbLockdownProfile query for " + pdbLockdownProfile + " is SELECT UPPER(VALUE) AS PDB_LOCKDOWN FROM V$PARAMETER WHERE UPPER(NAME) = 'PDB_LOCKDOWN'");
            if (pdbLockdownProfile == null) {
                this.lockdownProfile = LockdownProfile.NONE;
                return;
            }
            String cloudService = SqlUtils.getSingleString("SELECT UPPER(SYS_CONTEXT('USERENV', 'CLOUD_SERVICE')) FROM DUAL", this);
            log.fine("cloudService query for " + cloudService + " is SELECT UPPER(SYS_CONTEXT('USERENV', 'CLOUD_SERVICE')) FROM DUAL");
            if (cloudService == null) {
                this.lockdownProfile = LockdownProfile.NOT_AUTONOMOUS;
                return;
            }
            this.lockdownProfile = LockdownProfile.fromLockdownProfileAndCloudService(pdbLockdownProfile, cloudService);
        }
        catch (SQLException e) {
            log.trace("Exception attempting to determine the source database's lockdown profile.", e);
            this.lockdownProfile = LockdownProfile.NONE;
        }
    }

    public boolean isAutonomousSource() {
        return this.lockdownProfile.isAutonomous();
    }

    public boolean isAutonomousTarget() {
        return this.getParsedArgs().getTargetCloud().isAutonomous();
    }

    private String getValidatedPdbName(String pdbName) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block6: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.pds.getConnection();
            String verifyPdbNameSql = "SELECT PDB_NAME FROM SYS.DBA_PDBS WHERE UPPER(PDB_NAME)=UPPER(?)";
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT PDB_NAME FROM SYS.DBA_PDBS WHERE UPPER(PDB_NAME)=UPPER(?)");
            stmt.setString(1, pdbName);
            rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            String string = rs.getString(1);
            this.closeIfNotNull(rs, stmt, conn);
            return string;
        }
        try {
            try {
                throw new SQLException(Utilities.getErrorText("ERROR1007", new String[0]));
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 942) {
                    throw new SQLException(Utilities.getErrorText("ERROR1006", new String[0]), e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterSessionSetContainer(String givenPdbName) throws SQLException {
        String pdbName = this.getValidatedPdbName(givenPdbName);
        Connection conn = null;
        PreparedStatement alterSessionStatement = null;
        try {
            conn = this.pds.getConnection();
            String alterSessionSql = "ALTER SESSION SET CONTAINER=\"" + pdbName + "\"";
            alterSessionStatement = conn.prepareStatement(alterSessionSql);
            alterSessionStatement.execute();
        }
        catch (Throwable throwable) {
            this.closeIfNotNull(null, alterSessionStatement, conn);
            throw throwable;
        }
        this.closeIfNotNull(null, alterSessionStatement, conn);
    }

    public boolean hasDatabaseObject(DatabaseObject dbObj) {
        String sqlQuery;
        Boolean hasDbObj = this.hasDatabaseObjectCache.get(dbObj);
        if (hasDbObj != null) {
            return hasDbObj;
        }
        if (dbObj.getTable() != null) {
            sqlQuery = SqlUtils.getTableAndColumnNameQuery(dbObj);
        } else if (dbObj.getView() != null) {
            sqlQuery = SqlUtils.getViewAndColumnNameQuery(dbObj);
        } else {
            throw new IllegalArgumentException("Invalid Premigration DatabaseObject.");
        }
        try {
            log.fine("hasDatabaseObject query for " + dbObj + " is " + sqlQuery);
            hasDbObj = SqlUtils.getSingleLong(sqlQuery, this) > 0L;
        }
        catch (SQLException e) {
            log.severe("Exception attempting to determine if " + dbObj + " object exists", e);
            hasDbObj = false;
        }
        this.hasDatabaseObjectCache.put(dbObj, hasDbObj);
        return hasDbObj;
    }

    public boolean canSelectDatabaseObject(DatabaseObject dbObj) {
        Boolean canSelectDBObj = this.canSelectDatabaseObjectCache.get(dbObj);
        if (canSelectDBObj != null) {
            return canSelectDBObj;
        }
        String columnOrAsterisk = dbObj.getColumn() == null ? "*" : dbObj.getColumn();
        StringBuilder sqlQueryBuilder = new StringBuilder("SELECT COUNT(").append(columnOrAsterisk).append(") AS COUNT FROM ");
        if (dbObj.getSchema() != null) {
            sqlQueryBuilder.append(dbObj.getSchema()).append(".");
        }
        if (dbObj.getTable() != null) {
            sqlQueryBuilder.append(dbObj.getTable());
        } else if (dbObj.getView() != null) {
            sqlQueryBuilder.append(dbObj.getView());
        } else {
            throw new IllegalArgumentException("Invalid Premigration DatabaseObject.");
        }
        sqlQueryBuilder.append(" WHERE ROWNUM=1");
        try {
            String sqlQuery = sqlQueryBuilder.toString();
            log.fine("canSelectDatabaseObject query for " + dbObj + " is " + sqlQuery);
            canSelectDBObj = SqlUtils.getSingleLong(sqlQuery, this) > -1L;
        }
        catch (SQLException e) {
            canSelectDBObj = false;
            if (e.getErrorCode() == 942) {
                log.fine("ORA-00942 attempting to determine if " + dbObj + " object can be selected");
            }
            log.severe("Unexpected exception attempting to determine if " + dbObj + " object can be selected", e);
        }
        this.canSelectDatabaseObjectCache.put(dbObj, canSelectDBObj);
        return canSelectDBObj;
    }

    public EnvironmentContext getEnvCtx() {
        return this.envCtx;
    }

    public CommandLineArgs getParsedArgs() {
        return this.parsedArgs;
    }

    public List<String> getInvalidSchemaNames() {
        return this.invalidSchemaNames;
    }

    public OutputFilenamesContainer getOutputFilenamesContainer() {
        return this.outputFilenamesContainer;
    }

    public void setOutputFilenamesContainer(OutputFilenamesContainer outputFilenamesContainer) {
        this.outputFilenamesContainer = outputFilenamesContainer;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDatabasePlatformHW() {
        return this.databasePlatformHW;
    }

    public String getDatabasePlatformOS() {
        return this.databasePlatformOS;
    }

    public long getDatabasePlatformID() {
        return this.databasePlatformID;
    }

    public boolean isDatabaseIsCDB() {
        return this.databaseIsCDB;
    }

    public LockdownProfile getLockdownProfile() {
        return this.lockdownProfile;
    }

    public FilterCriteria getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(FilterCriteria filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public Set<String> getSkipChecks() {
        return this.skipChecks;
    }

    public Set<ZipContributor> getZipContents() {
        return this.zipContents;
    }

    public Properties getAnalysisProperties() {
        return this.analysisProperties;
    }

    public Properties getDefaultAnalysisProperties() {
        return this.defaultAnalysisProperties;
    }

    public boolean hasOracleMaintained() {
        return this.hasOracleMaintained;
    }

    public boolean hasDbmsCloudPkg() {
        return this.hasDbmsCloudPkg;
    }

    public AnalysisMode getAnalysisMode() {
        return this.analysisMode;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public boolean isCdbRootConnection() {
        return this.cdbRootConnection;
    }
}

