/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import java.util.ArrayList;
import java.util.List;

public enum Version {
    V10_1_0_2(2),
    V11_2_0_1(11),
    V11_2_0_2(14),
    V11_2_0_4(14),
    V12_1_0_1(18),
    V12_1_0_2(18),
    V12_2_0_1(26),
    V12_2_0_2(26),
    V18_0_0_0(31),
    V18_1_0_0(31),
    V19_1_0_0(32),
    V19_6_0_0(32),
    V19_18_0_0(32),
    V21_1_0_0(35),
    V23_4_0_0(43);

    final List<Integer> versionInts;
    final String dottedVersion;
    final int minTimeZoneVersion;

    private Version(int minTimeZoneVersion) {
        this.minTimeZoneVersion = minTimeZoneVersion;
        this.dottedVersion = this.name().substring(1).replace("_", ".");
        this.versionInts = Version.toList(this.dottedVersion);
    }

    public List<Integer> asList() {
        return this.versionInts;
    }

    public int compare(Version b) {
        return Version.compare(this.asList(), b.asList());
    }

    public int compare(String version) {
        List<Integer> b = Version.toList(version);
        return Version.compare(this.asList(), b);
    }

    public static int compare(List<Integer> a, List<Integer> b) {
        while (a.size() < b.size()) {
            a.add(0);
        }
        while (b.size() < a.size()) {
            b.add(0);
        }
        for (int i = 0; i < a.size(); ++i) {
            int b1;
            int a1 = a.get(i);
            if (a1 > (b1 = b.get(i).intValue())) {
                return 1;
            }
            if (a1 >= b1) continue;
            return -1;
        }
        return 0;
    }

    public static boolean betweenInclusive(String version, Version lowerBound, Version upperBound) {
        List<Integer> a = Version.toList(version);
        return Version.compare(a, lowerBound.asList()) >= 0 && Version.compare(a, upperBound.asList()) <= 0;
    }

    public int getMinTimeZoneVersion() {
        return this.minTimeZoneVersion;
    }

    public static Version getNearest(List<Integer> databaseVersionIntegers) {
        Version nearest = V10_1_0_2;
        if (databaseVersionIntegers == null || databaseVersionIntegers.contains(null)) {
            return null;
        }
        for (Version version : Version.values()) {
            int directComparison = Version.compare(version.asList(), databaseVersionIntegers);
            if (directComparison == 0) {
                return version;
            }
            int nearestComparison = version.compare(nearest);
            int dbComparison = Version.compare(version.asList(), databaseVersionIntegers);
            if (nearestComparison <= 0 || dbComparison >= 0) continue;
            nearest = version;
        }
        return nearest;
    }

    public static List<Integer> toList(String versionStr) {
        String[] split;
        ArrayList<Integer> version = new ArrayList<Integer>();
        String trimVersion = versionStr.trim();
        String canonicalVersion = trimVersion.endsWith(".") ? trimVersion + "0" : trimVersion;
        for (String element : split = canonicalVersion.split("\\.")) {
            version.add(Integer.parseInt(element));
        }
        return version;
    }

    public String toString() {
        return this.dottedVersion;
    }
}

