/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.api;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.io.OutputFilenamesContainer;
import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.commons.io.ZipFileHelper;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CDBSourceInspector;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.SourceInspector;
import com.oracle.premigration.dbinspector.TargetInspector;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleDriver;

public class Premigration {
    static final Language lang = Language.getInstanceWithDefaultResources();

    private Premigration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(CommandLineArgs parsedCla, EnvironmentContext envCtx) {
        String logFilePath;
        block28: {
            int errorMessage2;
            block27: {
                long startPremigrationRun = System.currentTimeMillis();
                PremigrationLogger log = null;
                logFilePath = null;
                ExecutionContext exeCtx = null;
                CommandLineArgs cla = CommandLineArgs.applyDefaultValuesCommandLine(parsedCla);
                boolean generateZip = cla.isGenZipFile();
                try {
                    if (cla.isVersion()) {
                        AppVersion.printVersionInfo(envCtx.getPrintStream());
                        int n = CheckResult.PASS.getExitCode();
                        return n;
                    }
                    if (cla.isSimpleVersion()) {
                        envCtx.getPrintStream().println(AppVersion.getVersionString());
                        int n = CheckResult.PASS.getExitCode();
                        return n;
                    }
                    if (cla.getCompareVersion() != null) {
                        int n = AppVersion.compareAppVersion(cla.getCompareVersion());
                        return n;
                    }
                    if (cla.isCheckForUpdates()) {
                        int n = AppVersion.checkForUpdates();
                        return n;
                    }
                    OutputFilenamesContainer outputFilenamesContainer = new OutputFilenamesContainer(cla.getOutFilePrefix(), cla.getOutdir());
                    logFilePath = outputFilenamesContainer.getValidatedLogFilePath();
                    PremigrationLogger.newConfig(logFilePath, cla.getLoggingLevel(), envCtx.getCommandInvocationMode());
                    log = PremigrationLogger.getLogger(Premigration.class.getName());
                    cla.validate(envCtx);
                    String appVersion = AppVersion.getVersionString();
                    String banner = lang.txt("APP_BANNER_MSG", appVersion);
                    log.info(banner);
                    log.info("Days since the jar was built: " + AppVersion.getAppAgeInDays());
                    Utilities.logEnvironmentVariables();
                    Utilities.logJavaProperties();
                    Utilities.logMemorySize(envCtx);
                    log.info("JDBC Driver Version: " + OracleDriver.getDriverVersion());
                    log.info(Utilities.getMaxAllowedKeyLengthInfo());
                    log.info("Effective command line: " + cla.getReconstitutedArgs());
                    envCtx.getPrintStream().println(banner);
                    exeCtx = new ExecutionContext(cla, outputFilenamesContainer, envCtx);
                    if (exeCtx.isAnalysisOfMultiplePdbs()) {
                        log.shutdown();
                        outputFilenamesContainer = exeCtx.getOutputFilenamesContainer().renameFilesForCDBSummary();
                        logFilePath = outputFilenamesContainer.getValidatedLogFilePath();
                        PremigrationLogger.newConfig(logFilePath, cla.getLoggingLevel(), envCtx.getCommandInvocationMode(), true);
                        log = PremigrationLogger.getLogger(Premigration.class.getName());
                        exeCtx.setOutputFilenamesContainer(outputFilenamesContainer);
                    }
                    if (generateZip) {
                        String logFileName = outputFilenamesContainer.getLogOutputFilename();
                        ZipContributor logFileForZip = ZipFileHelper.createZipContributorForFile(logFileName, logFilePath);
                        exeCtx.getZipContents().add(logFileForZip);
                    }
                    if (cla.getMaxSubprocesses() != null && !exeCtx.isAnalysisOfMultiplePdbs()) {
                        String errorMessage2 = Utilities.getErrorText("ERROR1021", new String[0]);
                        Utilities.printAndLogErrorMessage(errorMessage2, envCtx, Level.INFO);
                        cla.setMaxSubprocesses(null);
                    }
                    CheckResult overallResult = cla.isFetchTargetProps() ? TargetInspector.fetchTargetProps(exeCtx, appVersion) : (exeCtx.isAnalysisOfMultiplePdbs() ? CDBSourceInspector.analyzeSourcePDBs(exeCtx, appVersion) : SourceInspector.analyzeSource(exeCtx, appVersion));
                    log.info("Elapsed time executing Premigration Advisor: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startPremigrationRun));
                    log.trace("Returning overall integer result to CLI: " + overallResult.getExitCode());
                    errorMessage2 = overallResult.getExitCode();
                    if (log != null) {
                        log.shutdown();
                    }
                    if (!generateZip) break block27;
                }
                catch (FileNotFoundException e) {
                    String FileErrorMsg = Utilities.getErrorText("ERROR3002", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, FileErrorMsg, e);
                    break block28;
                }
                catch (AccessDeniedException | IOException e) {
                    String ioErrorMsg = PremigrationLogger.isLoggerInitialized() ? Utilities.getErrorText("ERROR3000", e, new String[0]) : Utilities.getErrorTextNoAction("ERROR3000", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, ioErrorMsg, e);
                    break block28;
                }
                catch (SQLException e) {
                    String connectString = cla.getConnectString();
                    boolean isNotValidConnectionString = connectString == null || !connectString.contains("jdbc:oracle:thin:@") && !connectString.contains("jdbc:oracle:oci:@") && !connectString.contains("jdbc:oracle:oci8:@");
                    String sqlErrorMsg = isNotValidConnectionString ? Utilities.getErrorText("ERROR1014", e, new String[0]) : Utilities.getErrorText("ERROR1004", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, sqlErrorMsg, e);
                    break block28;
                }
                catch (Exception e) {
                    String fatalMsg = Utilities.getErrorText("ERROR1005", e, new String[0]);
                    Premigration.commonErrorHandling(log, envCtx, fatalMsg, e);
                    if (e instanceof ArithmeticException) {
                        String msg = lang.txt("APP_POSSIBLE_EXPIRED_ACCOUNT_MSG");
                        Utilities.printAndLogErrorMessage(msg, envCtx, Level.SEVERE);
                    }
                    break block28;
                }
                finally {
                    if (log != null) {
                        log.shutdown();
                    }
                    if (generateZip) {
                        ZipFileHelper.generateZipFile(exeCtx);
                    }
                }
                ZipFileHelper.generateZipFile(exeCtx);
            }
            return errorMessage2;
        }
        if (PremigrationLogger.isLoggerInitialized() && logFilePath != null) {
            envCtx.getErrWriter().println(lang.txt("APP_LOG_FILE_DETAILS_MSG", logFilePath));
        }
        return CheckResult.FATAL.getExitCode();
    }

    private static void commonErrorHandling(PremigrationLogger log, EnvironmentContext envCtx, String errorMsg, Throwable t) {
        envCtx.getErrWriter().println(errorMsg);
        if (log != null) {
            log.severe(errorMsg, t);
        }
    }
}

