/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration;

import com.oracle.premigration.api.Premigration;
import com.oracle.premigration.cli.CommandInvocationMode;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.cli.CommandParser;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.helpers.Utilities;
import java.io.PrintWriter;
import org.apache.commons.cli.ParseException;

public class PremigrationApp {
    public int runFromCLI(String[] args) {
        PrintWriter printWriter = new PrintWriter(System.err, true);
        try {
            CommandParser commandParser = new CommandParser();
            CommandLineArgs cla = commandParser.parse(args);
            String command = Utilities.getPremigrationCommand();
            EnvironmentContext envCtx = new EnvironmentContext(CommandInvocationMode.RUN_FROM_CLI, System.out, printWriter, null, cla.isQuiet());
            if (cla.isHelp()) {
                PrintWriter pw = new PrintWriter(envCtx.getPrintStream());
                commandParser.printHelp(command, pw);
                return CheckResult.PASS.getExitCode();
            }
            return Premigration.run(cla, envCtx);
        }
        catch (ParseException e) {
            String parseMsg = Utilities.getErrorText("ERROR1003", e, new String[0]);
            printWriter.println(parseMsg);
            return CheckResult.FATAL.getExitCode();
        }
    }

    public static void main(String[] args) {
        PremigrationApp cpat = new PremigrationApp();
        System.exit(cpat.runFromCLI(args));
    }
}

