/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.jdbc.internal.OracleConnection;

public class NLSUtils {
    public static final String NLS_LANG = "NLS_LANG";
    public static final String NLS_TERR = "NLS_TERR";
    public static final String NLS_SORT = "NLS_SORT";
    public static final String NLS_COMP = "NLS_COMP";
    public static final String NLS_DATE_LANG = "NLS_DATE_LANG";
    public static final String NLS_DATE_FORM = "NLS_DATE_FORM";
    public static final String NLS_TS_FORM = "NLS_TS_FORM";
    public static final String NLS_TS_TZ_FORM = "NLS_TS_TZ_FORM";
    public static final String NLS_DEC_SEP = "NLS_DEC_SEP";
    public static final String NLS_GRP_SEP = "NLS_GRP_SEP";
    public static final String NLS_CURR = "NLS_CURR";
    public static final String NLS_ISO_CURR = "NLS_ISO_CURR";
    public static final String NLS_LENGTH = "NLS_LENGTH";

    public static void setNlsFromPrefs(Connection dbCon) {
        NLSProvider.getProvider(dbCon).setNlsFromPrefs();
    }

    public static Object getValue(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).getValue(obj);
    }

    public static Object getValue(Connection conn, Object obj, FormatType formatType) {
        if (formatType == null) {
            return NLSProvider.getProvider(conn).getValue(obj);
        }
        return NLSProvider.getProvider(conn).getValue(obj, formatType);
    }

    public static void updateDefaults(Connection conn, Map<String, String> map) {
        NLSProvider.getProvider(conn).updateDefaults(map);
    }

    public static void populateNLS(Connection conn) {
        NLSProvider.getProvider(conn).populateNLS();
    }

    public static Format getFormat(Connection conn, int sqlType, FormatType formatType) {
        return NLSProvider.getProvider(conn).getFormat(sqlType, formatType);
    }

    public static String getDateFormat(Connection conn, FormatType formatType) {
        return NLSProvider.getProvider(conn).getDateFormat(formatType);
    }

    public static String getTimeStampWithTimeZoneFormat(Connection conn, FormatType formatType) {
        return NLSProvider.getProvider(conn).getTimeStampWithTimeZoneFormat(formatType);
    }

    public static String getTimeStampFormat(Connection conn, FormatType formatType) {
        return NLSProvider.getProvider(conn).getTimeStampFormat(formatType);
    }

    public static Format getFormat(Connection conn, int sqlType) {
        return NLSProvider.getProvider(conn).getFormat(sqlType);
    }

    public static String getDateFormat(Connection conn) {
        return NLSUtils.getDateFormat(conn, FormatType.PREFERRED);
    }

    public static String getTimeStampWithTimeZoneFormat(Connection conn) {
        return NLSUtils.getTimeStampWithTimeZoneFormat(conn, FormatType.PREFERRED);
    }

    public static String getTimeStampFormat(Connection conn) {
        return NLSUtils.getTimeStampFormat(conn, FormatType.PREFERRED);
    }

    public static char getDecimalSeparator(Connection conn) {
        return NLSProvider.getProvider(conn).getDecimalSeparator();
    }

    public static String toSql(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).getSQL(obj);
    }

    public static String format(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).format(obj);
    }

    public static String getDBCharset(Connection conn) {
        return NLSProvider.getProvider(conn).getDBCharset();
    }

    public static TimeZone getDatabaseTimeZone(Connection conn) {
        return NLSProvider.getProvider(conn).getDatabaseTimeZone();
    }

    public static TimeZone getSessionTimeZone(Connection conn) {
        return NLSProvider.getProvider(conn).getSessionTimeZone();
    }

    public static String getNullDisplay(Connection conn) {
        return NLSProvider.getProvider(conn).getNullDisplay();
    }

    public static String yieldNullDisplay(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).yieldNullDisplay(obj);
    }

    public static boolean isNullOrEquiv(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).isNullOrEquiv(obj);
    }

    public static boolean isNullDisplay(Connection conn, Object obj) {
        return NLSProvider.getProvider(conn).isNullDisplay(obj);
    }

    public static void setNullDisplay(Connection conn, String nullDisplay) {
        NLSProvider.getProvider(conn).setNullDisplay(nullDisplay);
    }

    public static Locale getNLSSessionLocale(Connection conn) {
        Locale locale = Locale.getDefault();
        if (!(conn instanceof OracleConnection)) {
            return locale;
        }
        try {
            Properties ssProp = ((OracleConnection)conn).getServerSessionInfo();
            String nlsLang = (String)ssProp.get("AUTH_NLS_LXLAN");
            if (nlsLang != null) {
                if (nlsLang.equalsIgnoreCase("GERMAN")) {
                    locale = Locale.GERMAN;
                } else if (nlsLang.equalsIgnoreCase("SPANISH")) {
                    locale = new Locale("es", "ES");
                } else if (nlsLang.equalsIgnoreCase("FRENCH")) {
                    locale = Locale.FRENCH;
                } else if (nlsLang.equalsIgnoreCase("ITALIAN")) {
                    locale = Locale.ITALIAN;
                } else if (nlsLang.equalsIgnoreCase("JAPANESE")) {
                    locale = Locale.JAPANESE;
                } else if (nlsLang.equalsIgnoreCase("KOREAN")) {
                    locale = Locale.KOREAN;
                } else if (nlsLang.equalsIgnoreCase("BRAZILIAN PORTUGUESE")) {
                    locale = new Locale("pt", "BR");
                } else if (nlsLang.equalsIgnoreCase("SIMPLIFIED CHINESE")) {
                    locale = Locale.SIMPLIFIED_CHINESE;
                } else if (nlsLang.equalsIgnoreCase("TRADITIONAL CHINESE")) {
                    locale = Locale.TAIWAN;
                } else if (nlsLang.equalsIgnoreCase("AMERICAN")) {
                    locale = Locale.US;
                } else if (nlsLang.equalsIgnoreCase("ENGLISH")) {
                    locale = Locale.UK;
                }
            }
        }
        catch (SQLException e) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

