/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ObjectQueries {
    private List<Query> m_queryList;
    private Query m_default;
    private Map<VersionEntry, Query> m_queryMap = new TreeMap<VersionEntry, Query>();
    private XMLNode m_node;

    public ObjectQueries(XMLNode node) {
        this.m_node = node;
        this.initQueries(node);
    }

    public String getQueriesAttribute(String name) {
        if (this.m_node.getAttributes().getNamedItem(name) != null) {
            this.m_node.getAttributes().getNamedItem(name).getTextContent();
        }
        return null;
    }

    public void addQuery(Version minVer, Version maxVer, Query query) {
        this.m_queryMap.put(new VersionEntry(minVer, maxVer), query);
    }

    public void setDefaultQuery(Query query) {
        this.m_default = query;
    }

    public Query getQuery(ConnectionIdentifier id) {
        return QueryUtils.getQuery(this.m_queryList, id);
    }

    public Query getQuery(ConnectionIdentifier id, boolean prependDBA) {
        return QueryUtils.getQuery(this.m_queryList, id, prependDBA, false);
    }

    public Query getQueryNoCache(ConnectionIdentifier id) {
        return QueryUtils.getQuery(this.m_queryList, id, false, false, true);
    }

    public Query getQuery(Version ver) {
        Query result = null;
        for (VersionEntry ve : this.m_queryMap.keySet()) {
            if (ve.m_min != null && ver.compareTo(ve.m_min) < 0) break;
            if (ve.m_max != null && ver.compareTo(ve.m_max) > 0) continue;
            result = this.m_queryMap.get(ve);
        }
        return result != null ? result : this.m_default;
    }

    public int getLoadedQueryCount() {
        return this.m_queryList.size();
    }

    public List<Query> getQueries() {
        return Collections.unmodifiableList(this.m_queryList);
    }

    public void initQueries(Query query) {
        this.m_queryList = new ArrayList<Query>();
        this.m_queryList.add(query);
        Version min = query.getMinversion();
        Version max = query.getMaxversion();
        if (min == null && max == null) {
            this.setDefaultQuery(query);
        } else {
            this.addQuery(min, max, query);
        }
    }

    public void initQueries(XMLNode node) {
        XMLNode loadNode = node == null ? this.m_node : node;
        this.m_queryList = new ArrayList<Query>();
        if (loadNode != null) {
            this.m_queryList.addAll(Query.getQueries((Node)loadNode));
            for (Query query : this.m_queryList) {
                Version min = query.getMinversion();
                Version max = query.getMaxversion();
                if (min == null && max == null) {
                    this.setDefaultQuery(query);
                    continue;
                }
                this.addQuery(min, max, query);
            }
        }
    }

    private class VersionEntry
    implements Comparable<VersionEntry> {
        private Version m_min;
        private Version m_max;
        private static final int BEFORE = -1;
        private static final int AFTER = 1;
        private static final int EQUAL = 0;

        private VersionEntry(Version min, Version max) {
            assert (min != null || max != null);
            this.m_min = min;
            this.m_max = max;
        }

        @Override
        public int compareTo(VersionEntry other) {
            int order = 0;
            if (this == other) {
                order = 0;
            }
            if ((order = this.compare(this.m_min, other.m_min)) == 0) {
                order = this.compare(this.m_max, other.m_max);
            }
            return order;
        }

        private int compare(Version version1, Version version2) {
            if (version1 == version2) {
                return 0;
            }
            if (version1 == null) {
                return -1;
            }
            if (version2 == null) {
                return 1;
            }
            return version1.compareTo(version2);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof VersionEntry && ModelUtil.areEqual(this.m_min, ((VersionEntry)obj).m_min) && ModelUtil.areEqual(this.m_max, ((VersionEntry)obj).m_max);
        }

        public int hashCode() {
            return this.m_min.hashCode() + (this.m_max != null ? this.m_max.hashCode() : 0);
        }
    }
}

