/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AttributeContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ContainerObjectsBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Share;

public final class ShareBuilder {
    private final ContainerObjectsBuilder containerObjectsBuilder = new ContainerObjectsBuilder();

    public ShareBuilder with(AttributeContainer container) {
        this.containerObjectsBuilder.addContainer(container);
        return this;
    }

    public ShareBuilder add(Option<?> option) {
        this.containerObjectsBuilder.addOption(option);
        return this;
    }

    public ShareBuilder add(Parameter<?> parameter) {
        this.containerObjectsBuilder.addParameter(parameter);
        return this;
    }

    public ShareBuilder addHelpContainer(HelpContainer container) {
        this.containerObjectsBuilder.addHelpContainer(container);
        return this;
    }

    public ShareBuilder addHelpContainerFor(Object forObject) {
        this.containerObjectsBuilder.addHelpContainerFor(forObject);
        return this;
    }

    public ShareBuilder addHelpContainerFor(Object forObject, String bundleName) {
        this.containerObjectsBuilder.addHelpContainerFor(forObject, bundleName);
        return this;
    }

    public Share build() {
        return new ShareImpl(this.containerObjectsBuilder.build());
    }

    protected ShareBuilder() {
    }

    private static class ShareImpl
    implements Share {
        private final List<Option<?>> options;
        private final List<Parameter<?>> parameters;
        private final List<HelpContainer> helpContainers;

        private ShareImpl(ContainerObjectsBuilder.ContainerObjects containerObjects) {
            this.options = containerObjects.getOptions();
            this.parameters = containerObjects.getParameters();
            this.helpContainers = Collections.unmodifiableList(containerObjects.getHelpContainers());
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.options;
        }

        @Override
        public List<Parameter<?>> getParameters() {
            return this.parameters;
        }

        @Override
        public List<HelpContainer> getHelpContainers() {
            return this.helpContainers;
        }
    }
}

