/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class SeqBuilder
extends ExpressionBuilder {
    private final Transformer<List<Node>, ?> transformer;
    private final List<ExpressionBuilder> items;

    protected SeqBuilder(Transformer<List<Node>, ?> transformer, ExpressionBuilder ... items) {
        this.transformer = transformer;
        this.items = Arrays.asList(items);
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Seq(context, this));
    }

    private static class Seq
    implements Expression {
        private final Transformer<List<Node>, ?> transformer;
        private final List<Expression> items;

        Seq(GrammarBuildContext context, SeqBuilder builder) {
            this.transformer = builder.transformer;
            this.items = context.build(builder.items);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            boolean firstItem = true;
            for (Expression item : this.items) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    buff.append(' ');
                }
                Syntax itemSyntax = item.getSyntax();
                if (itemSyntax.bracketIfNested()) {
                    buff.append('(');
                }
                buff.append(itemSyntax.get());
                if (!itemSyntax.bracketIfNested()) continue;
                buff.append(')');
            }
            return new Syntax(buff.toString(), true);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            for (Expression item : this.items) {
                item.visitNamedExpressions(visitor);
            }
        }

        @Override
        public void parse(Node node) {
            boolean matched = true;
            for (Expression item : this.items) {
                Node childNode = node.createChildContext(item);
                item.parse(childNode);
                node.mergeCompletions(childNode.getCompletions());
                node.mergeSemanticErrors(childNode.getSemanticErrors());
                node.mergeParseError(childNode.getParseError());
                if (childNode.isMatched()) {
                    node.addChildNode(childNode);
                    continue;
                }
                matched = false;
                break;
            }
            if (matched) {
                node.setValueFrom(node.getChildNodes(), this.transformer);
                node.setMatched();
            }
        }

        public String toString() {
            return "SEQ";
        }
    }
}

